/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.config.AppConfig;
import app.utils.config.ServerConfig;
import app.utils.security.server.legacy.oidc.OidcAccessTokenFilter;
import app.utils.security.server.oauth.JwtAccessTokenFilter;
import app.utils.server.LivenessServlet;
import app.utils.server.ManagementEndpointsHTTPHandler;
import app.utils.server.ReadinessServlet;
import app.utils.server.ServletResourceManager;
import app.utils.server.ShutdownServlet;
import app.utils.server.management.info.InfoServlet;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.system.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.jmx.BuildInfoCollector;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Scanner;
import java.util.UUID;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.TLSServerParametersType;
import org.apache.cxf.jaxrs.provider.dom4j.DOM4JProvider;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jolokia.http.AgentServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppJetty {
    private static final Logger LOG = LoggerFactory.getLogger(AppJetty.class);

    public static CompositeConfiguration cfg() {
        return AppConfig.getInstance().getConfigs();
    }

    @Deprecated
    public static Server createServer() {
        int webPort = ServerConfig.getPort();
        return new Server(webPort);
    }

    @Deprecated
    public static void addCxfJaxRSServlet(ServletContextHandler servletContext, String applicationClassName) {
        ServletHolder cxfServletHolder = new ServletHolder((Servlet)new CXFNonSpringJaxrsServlet());
        cxfServletHolder.setInitParameter("jaxrs.serviceClasses", applicationClassName);
        cxfServletHolder.setInitParameter("jaxrs.providers", DOM4JProvider.class.getName());
        servletContext.addServlet(cxfServletHolder, ServerConfig.getServletContextPath() + "/*");
    }

    public static JettyHTTPServerEngine createServer(Bus cxfBus) {
        JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)cxfBus.getExtension(JettyHTTPServerEngineFactory.class);
        if (AppConfig.getBoolean("security.require-ssl", false)) {
            try {
                TLSServerParametersConfig params = AppJetty.getTLSConfig();
                serverEngineFactory.setTLSServerParametersForPort(ServerConfig.getHost(), ServerConfig.getPort(), (TLSServerParameters)params);
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error(String.format("Setting Jetty server SSL resulted in exception - port %d will not have SSL enabled", ServerConfig.getPort()), (Throwable)e);
            }
        }
        try {
            return serverEngineFactory.createJettyHTTPServerEngine(ServerConfig.getHost(), ServerConfig.getPort(), ServerConfig.getProtocol());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(String.format("Creatng Jetty server at %s://%s:%s resulted in exception", ServerConfig.getProtocol(), ServerConfig.getHost(), ServerConfig.getPort()), e);
        }
    }

    public static void startServer(Bus cxfBus, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext) {
        ManagementEndpointsHTTPHandler jettyHttpHandler = new ManagementEndpointsHTTPHandler(cxfBus, servletContext, ServerConfig.getMgmtContextPath());
        try {
            URL mgmtUrl = new URL(ServerConfig.getMgmtEndpointsPrefix());
            serverEngine.addServant(mgmtUrl, (JettyHTTPHandler)jettyHttpHandler);
            servletContext.setServer(serverEngine.getServer());
            serverEngine.getServer().addManaged((LifeCycle)servletContext);
        }
        catch (MalformedURLException e) {
            LOG.error(String.format("Converting %s to URL resulted in exception - management endpoints will not be available", ServerConfig.getMgmtEndpointsPrefix()), (Throwable)e);
        }
    }

    public static void addMgmtEndpoints(JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        AppJetty.addMgmtServlets(null, serverEngine, servletContext, includePrometheus);
    }

    public static void addMgmtEndpoints(CamelContext camelContext, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        AppJetty.addMgmtServlets(camelContext, serverEngine, servletContext, includePrometheus);
    }

    protected static void addMgmtServlets(CamelContext camelContext, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        boolean addAuth = AppConfig.getBoolean("management.endpoints.secured", true);
        for (String endpointToAdd : ServerConfig.getMgmtEndpointsToAdd()) {
            if ("jolokia".equals(endpointToAdd)) {
                AppJetty.addJolokiaServlet(servletContext);
                continue;
            }
            if (includePrometheus && "prometheus".equals(endpointToAdd)) {
                AppJetty.addPrometheusServlet(servletContext, addAuth);
                continue;
            }
            if ("health".equals(endpointToAdd)) {
                AppJetty.addServlet(servletContext, new LivenessServlet(camelContext), "health", addAuth);
                AppJetty.addServlet(servletContext, new ReadinessServlet(camelContext), "ready", addAuth);
                continue;
            }
            if ("info".equals(endpointToAdd)) {
                AppJetty.addServlet(servletContext, new InfoServlet(camelContext), "info", addAuth);
                continue;
            }
            if (!"shutdown".equals(endpointToAdd)) continue;
            AppJetty.addServlet(servletContext, new ShutdownServlet(camelContext, serverEngine), "shutdown", true);
        }
    }

    public static void addJolokiaServlet(ServletContextHandler servletContext) {
        ServletHolder jolokiaServlet = new ServletHolder("jolokia", AgentServlet.class);
        String suffix = String.format("/%s/*", "jolokia");
        servletContext.addServlet(jolokiaServlet, suffix);
        AppJetty.addBasicAuthentication(servletContext, suffix);
    }

    public static void addPrometheusServlet(ServletContextHandler servletContext, boolean addAuth) {
        CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
        PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT, collectorRegistry, Clock.SYSTEM);
        new UptimeMetrics().bindTo((MeterRegistry)meterRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)meterRegistry);
        new DiskSpaceMetrics(new File(".")).bindTo((MeterRegistry)meterRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
        jvmGcMetrics.bindTo((MeterRegistry)meterRegistry);
        JvmHeapPressureMetrics jvmHeapPressureMetrics = new JvmHeapPressureMetrics();
        jvmHeapPressureMetrics.bindTo((MeterRegistry)meterRegistry);
        Log4j2Metrics log4j2Metrics = new Log4j2Metrics();
        log4j2Metrics.bindTo((MeterRegistry)meterRegistry);
        new JettyConnectionMetrics((MeterRegistry)meterRegistry);
        new JettySslHandshakeMetrics((MeterRegistry)meterRegistry);
        new BuildInfoCollector().register(collectorRegistry);
        String sourceFileLocation = "config/jmx-prometheus.yaml";
        try (InputStream resourceAsStream = AppJetty.class.getClassLoader().getResourceAsStream(sourceFileLocation);){
            if (resourceAsStream != null) {
                new JmxCollector(resourceAsStream).register(collectorRegistry);
            } else {
                LOG.error("Failed to load file " + sourceFileLocation + ", Prometheus JMX metrics collector will not be registered");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize Prometheus JMX metrics collector", (Throwable)e);
        }
        ServletResourceManager resourceManager = new ServletResourceManager(new AutoCloseable[]{jvmGcMetrics, jvmHeapPressureMetrics, log4j2Metrics});
        servletContext.addEventListener((EventListener)((Object)resourceManager));
        ServletHolder prometheusServlet = new ServletHolder("prometheus", (Servlet)new MetricsServlet(meterRegistry.getPrometheusRegistry()));
        String suffix = String.format("/%s", "prometheus");
        servletContext.addServlet(prometheusServlet, suffix);
        if (addAuth) {
            AppJetty.addBasicAuthentication(servletContext, suffix);
        }
    }

    public static void addServlet(ServletContextHandler servletContext, HttpServlet servlet, String mgmtEndpoint, boolean addAuth) {
        ServletHolder mgmtServlet = new ServletHolder((Servlet)servlet);
        String suffix = String.format("/%s", mgmtEndpoint);
        servletContext.addServlet(mgmtServlet, suffix);
        if (addAuth) {
            AppJetty.addBasicAuthentication(servletContext, suffix);
        }
    }

    public static void addJmxManagement(Bus cxfBus) {
        InstrumentationManagerImpl im = new InstrumentationManagerImpl(cxfBus);
        im.setUsePlatformMBeanServer(Boolean.valueOf(true));
        im.getMBeanServer();
        im.setBus(cxfBus);
        im.setEnabled(true);
        im.init();
        CounterRepository cxfCounter = new CounterRepository();
        cxfCounter.setBus(cxfBus);
    }

    public static void addCrossOriginFilter(ServletContextHandler servletContext) {
        FilterHolder holder = new FilterHolder(CrossOriginFilter.class);
        holder.setName("cross-origin");
        servletContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addBasicAuthentication(ServletContextHandler servletContext, String constraintPath) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        if (servletContext.getSecurityHandler() == null) {
            ConstraintSecurityHandler security = new ConstraintSecurityHandler();
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec(constraintPath);
            mapping.setConstraint(constraint);
            security.setConstraintMappings(Collections.singletonList(mapping));
            BasicAuthenticator authenticator = new BasicAuthenticator();
            servletContext.setSecurityHandler((SecurityHandler)security);
            String realmName = "TalendRealm";
            security.setRealmName(realmName);
            security.setAuthenticator((Authenticator)authenticator);
            UserStore userStore = new UserStore();
            userStore.addUser(AppJetty.cfg().getString("security.user.name"), (Credential)new Password(AppJetty.cfg().getString("security.user.password")), new String[]{"user"});
            HashLoginService loginService = new HashLoginService();
            loginService.setName(realmName);
            loginService.setUserStore(userStore);
            security.setLoginService((LoginService)loginService);
        } else {
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec(constraintPath);
            mapping.setConstraint(constraint);
            ConstraintSecurityHandler security = (ConstraintSecurityHandler)servletContext.getSecurityHandler();
            security.getConstraintMappings().add(mapping);
        }
    }

    public static void addLegacyOIDCViaFilter(ServletContextHandler servletContext, String constraintPath) {
        OidcAccessTokenFilter filter = new OidcAccessTokenFilter(AppJetty.cfg().getString("validation.endpoint"));
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addJWTAuthorizationViaFilter(ServletContextHandler servletContext, String constraintPath) {
        JwtAccessTokenFilter filter = new JwtAccessTokenFilter();
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addSSLSupport(Bus cxfBus, int ... ports) throws IOException, GeneralSecurityException {
        if (AppConfig.getBoolean("security.require-ssl", false)) {
            JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)cxfBus.getExtension(JettyHTTPServerEngineFactory.class);
            TLSServerParametersConfig params = AppJetty.getTLSConfig();
            for (int port : ports) {
                serverEngineFactory.setTLSServerParametersForPort(port, (TLSServerParameters)params);
            }
        }
    }

    protected static TLSServerParametersConfig getTLSConfig() throws IOException, GeneralSecurityException {
        TLSServerParametersType tlsServerParameters = new TLSServerParametersType();
        tlsServerParameters.setCertAlias(AppJetty.cfg().getString("server.ssl.key-store-alias"));
        ClientAuthentication cau = new ClientAuthentication();
        cau.setRequired(Boolean.valueOf(false));
        cau.setWant(Boolean.valueOf(false));
        tlsServerParameters.setClientAuthentication(cau);
        KeyManagersType kmt = new KeyManagersType();
        KeyStoreType kst = new KeyStoreType();
        kst.setFile(Paths.get(AppJetty.cfg().getString("server.ssl.key-store"), new String[0]).toAbsolutePath().toString());
        kst.setPassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
        kst.setType(AppJetty.cfg().getString("server.ssl.key-store-type"));
        kmt.setKeyStore(kst);
        kmt.setKeyPassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
        tlsServerParameters.setKeyManagers(kmt);
        return new TLSServerParametersConfig(tlsServerParameters);
    }

    public static void addSSLSupport(Server server) {
        if (AppConfig.getBoolean("security.require-ssl", false)) {
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.setSecureScheme("https");
            https_config.setSecurePort(ServerConfig.getPort());
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            https_config.addCustomizer((HttpConfiguration.Customizer)src);
            File keystoreFile = Paths.get(AppJetty.cfg().getString("server.ssl.key-store"), new String[0]).toFile();
            if (!keystoreFile.exists()) {
                throw new RuntimeException("Could not setup keystore {} file not found" + keystoreFile.getAbsolutePath());
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
            sslContextFactory.setKeyStoreType(AppJetty.cfg().getString("server.ssl.key-store-type"));
            sslContextFactory.setCertAlias(AppJetty.cfg().getString("server.ssl.key-store-alias"));
            try {
                sslContextFactory.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
            https.setPort(ServerConfig.getPort());
            https.setHost(ServerConfig.getHost());
            server.setConnectors(new Connector[]{https});
        }
    }

    public static SSLContextParameters buildSSLContext() {
        CompositeConfiguration cfg = AppConfig.getInstance().getConfigs();
        if (cfg.getBoolean("security.require-ssl", false)) {
            KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
            keyStoreParameters.setResource(cfg.getString("server.ssl.key-store"));
            keyStoreParameters.setPassword(cfg.getString("server.ssl.key-store-password"));
            KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
            keyManagersParameters.setKeyStore(keyStoreParameters);
            SSLContextParameters sslContextParameters = new SSLContextParameters();
            sslContextParameters.setKeyManagers(keyManagersParameters);
            sslContextParameters.setCertAlias(cfg.getString("server.ssl.key-store-alias"));
            return sslContextParameters;
        }
        return null;
    }

    public static void generateUserNameAndPassword() {
        String currentPassword;
        String currentUser = AppConfig.getString("security.user.name");
        boolean doReload = false;
        if (StringUtils.isEmpty((CharSequence)currentUser)) {
            currentUser = "user";
            System.setProperty("security.user.name", currentUser);
            doReload = true;
            LOG.warn("username is not available, generating");
        }
        if (StringUtils.isEmpty((CharSequence)(currentPassword = AppConfig.getString("security.user.password")))) {
            currentPassword = UUID.randomUUID().toString();
            System.setProperty("security.user.password", currentPassword);
            doReload = true;
            LOG.warn("password is not available, generating");
            LOG.warn(String.format("%n%nUsing generated security credentials %nusername: %s %npassword: %s%n%nThis generated password is for development use only. %nYour security configuration must be updated before running your application in production.%n", currentUser, currentPassword));
        }
        if (doReload) {
            AppConfig.reload();
        }
    }

    public static void parseCmdLineAndPrintBanner(String[] args) {
        Options options = new Options();
        Option help = Option.builder((String)"h").longOpt("help").desc("print this message").build();
        Option contextParam = Option.builder().longOpt("context_param").desc("To override a context parameter or a property --context_param  key=value").numberOfArgs(2).valueSeparator('=').build();
        Option context = Option.builder().longOpt("context").desc("To set the context name ").hasArg().build();
        Option stat = Option.builder().longOpt("stat_port").desc("To set statistic port number ").hasArg().build();
        Option pid = Option.builder().longOpt("pid").desc("To force pid of the job ").hasArg().build();
        Option configLoc = Option.builder().longOpt("config_location").desc("To set the configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option configAdditionalLocLegacy = Option.builder().longOpt("spring.config.additional-location").desc("Alias for config_additional_location. To set the additional configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option configAdditionalLoc = Option.builder().longOpt("config_additional_location").desc("To set the additional configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option serverPortLegacy = Option.builder().longOpt("server.port").desc("Alias for server_port. he port on which the server will listen").hasArgs().build();
        Option serverPort = Option.builder().longOpt("server_port").desc("The port on which the server will listen").hasArgs().build();
        Option loggingConfigLegacy = Option.builder().longOpt("logging.config").desc("Alias for logging_config. Location of the logging configuration file").hasArgs().build();
        Option loggingConfig = Option.builder().longOpt("logging_config").desc("Location of the logging configuration file").hasArgs().build();
        Option banner = Option.builder().longOpt("banner").desc("To set the location of the banner file").hasArg().build();
        options.addOption(help).addOption(contextParam).addOption(context).addOption(stat).addOption(pid).addOption(configLoc).addOption(configAdditionalLocLegacy).addOption(configAdditionalLoc).addOption(serverPortLegacy).addOption(serverPort).addOption(loggingConfigLegacy).addOption(loggingConfig).addOption(banner);
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            String[] configFiles;
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption(help)) {
                helper.printHelp("Usage:", options);
                throw new RuntimeException("Exit");
            }
            if (cmd.hasOption(configLoc)) {
                configFiles = cmd.getOptionValues(configLoc);
                AppConfig.setConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(configAdditionalLocLegacy)) {
                configFiles = cmd.getOptionValues(configAdditionalLocLegacy);
                AppConfig.addConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(configAdditionalLoc)) {
                configFiles = cmd.getOptionValues(configAdditionalLoc);
                AppConfig.addConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(serverPortLegacy)) {
                System.setProperty("server.port", cmd.getOptionValue(serverPortLegacy));
            }
            if (cmd.hasOption(serverPort)) {
                System.setProperty("server.port", cmd.getOptionValue(serverPort));
            }
            if (cmd.hasOption(loggingConfigLegacy)) {
                System.setProperty("logging.config", cmd.getOptionValue(loggingConfigLegacy));
            }
            if (cmd.hasOption(loggingConfig)) {
                System.setProperty("logging.config", cmd.getOptionValue(loggingConfig));
            }
            if (cmd.hasOption(context)) {
                System.setProperty("context", cmd.getOptionValue(context));
            }
            if (cmd.hasOption(contextParam)) {
                AppConfig.addContextParamProperty(cmd.getOptionValues(contextParam)[0], cmd.getOptionValues(contextParam)[1]);
            }
            if (cmd.hasOption(banner)) {
                System.setProperty("banner.location", cmd.getOptionValue(banner));
            }
            if (cmd.hasOption(pid)) {
                System.setProperty("pid", cmd.getOptionValue(pid));
            }
            if (cmd.hasOption(stat)) {
                System.setProperty("stat_port", cmd.getOptionValue(stat));
            }
            AppConfig.reload();
            AppJetty.printBanner();
        }
        catch (ParseException e) {
            helper.printHelp("Usage:", options);
            throw new RuntimeException(e);
        }
    }

    private static void printBanner() {
        block16: {
            String bannerFileLocation = AppConfig.getNonEmptyString("banner.location", "config/banner.txt");
            try (InputStream resourceAsStream = AppConfig.getFileInputStream(bannerFileLocation);){
                if (resourceAsStream != null) {
                    try (Scanner scanner = new Scanner(resourceAsStream).useDelimiter("\\A");){
                        if (scanner.hasNext()) {
                            System.out.println(scanner.next());
                        }
                        break block16;
                    }
                }
                LOG.error("Failed to load banner file " + bannerFileLocation);
            }
            catch (IOException e) {
                LOG.error("Error while reading banner file ", (Object)e.getMessage());
            }
        }
    }
}

