/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class ManagementEndpointsHTTPHandler
extends JettyHTTPHandler {
    private static final List<String> ALL_ENDPOINTS_PATH = Arrays.asList(String.format("/%s", "jolokia"), String.format("/%s", "prometheus"), String.format("/%s", "health"), String.format("/%s", "ready"), String.format("/%s", "info"), String.format("/%s", "shutdown"));
    private final ServletContextHandler servletContext;
    private final String mgmtEndpointPath;

    public ManagementEndpointsHTTPHandler(Bus cxfBus, ServletContextHandler servletContext, String mgmtContextPath) {
        super(cxfBus);
        this.servletContext = servletContext;
        this.mgmtEndpointPath = mgmtContextPath.length() <= 1 && mgmtContextPath.endsWith("/") ? "" : mgmtContextPath;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.shouldHandle(target)) {
            target = String.format("%s%s", this.mgmtEndpointPath, target);
            this.servletContext.handle(target, baseRequest, request, response);
        }
    }

    private boolean shouldHandle(String target) {
        for (String endpointPath : ALL_ENDPOINTS_PATH) {
            if (!target.startsWith(endpointPath)) continue;
            return true;
        }
        return false;
    }
}

