/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.basic;

import app.utils.config.AppConfig;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasBasicAuthLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(JaasBasicAuthLoginModule.class);
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        return this.succeeded;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOG.debug("JaasBasicAuthLoginModule - initialize called");
        this.callbackHandler = callbackHandler;
        this.succeeded = false;
    }

    @Override
    public boolean login() throws LoginException {
        LOG.debug("JaasBasicAuthLoginModule - login called");
        if (this.callbackHandler == null) {
            throw new LoginException("Oops, callbackHandler is null");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("name:"), new PasswordCallback("password:", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException("Oops, IOException calling handle on callbackHandler");
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Oops, UnsupportedCallbackException calling handle on callbackHandler");
        }
        NameCallback nameCallback = (NameCallback)callbacks[0];
        PasswordCallback passwordCallback = (PasswordCallback)callbacks[1];
        String name = nameCallback.getName();
        String password = new String(passwordCallback.getPassword());
        String cfgName = AppConfig.getInstance().getConfigs().getString("security.user.name");
        String cfgPassword = AppConfig.getInstance().getConfigs().getString("security.user.password");
        if (cfgName != null && cfgName.equals(name) && cfgPassword != null && cfgPassword.equals(password)) {
            LOG.debug("JaasBasicAuthLoginModule - login Success");
            this.succeeded = true;
            return this.succeeded;
        }
        LOG.debug("JaasBasicAuthLoginModule - login Failed");
        this.succeeded = false;
        throw new FailedLoginException("login Failed");
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }
}

