/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.oauth;

import app.utils.config.AppConfig;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAccessTokenAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAccessTokenAuthenticator.class);
    private static final Set<String> REQUIRED_CLAIMS = Set.of("iss", "iat", "exp", "aud");
    private final JWKSource<SecurityContext> jwkSource;

    public JwtAccessTokenAuthenticator() {
        try {
            URI uri = new URI(AppConfig.getInstance().getConfigs().getString("oauth.provider.jwks.endpoint"));
            URL url = uri.toURL();
            this.jwkSource = JWKSourceBuilder.create((URL)url).cache(true).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyJWTAccessToken(request, accessToken)) {
            DefaultUserIdentity user = new DefaultUserIdentity(null, null, new String[]{"user"});
            return new UserAuthentication(this.getAuthMethod(), (UserIdentity)user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    private boolean verifyJWTAccessToken(HttpServletRequest request, String accessToken) {
        try {
            JWT decodedJwt = JWTParser.parse((String)accessToken);
            String algorithmName = decodedJwt.getHeader().getAlgorithm().toString();
            JWSAlgorithm algorithm = this.getAlgorithm(algorithmName);
            ConfigurableJWTProcessor<SecurityContext> processor = this.getProcessor(request, algorithm);
            processor.process(decodedJwt, null);
            LOG.debug("Access Token with algorithm {} is valid", (Object)algorithmName);
            return true;
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            LOG.error("Access Token is not valid", e);
        }
        catch (Exception e) {
            LOG.error("An unexpected error occurred during Access Token validation", (Throwable)e);
        }
        return false;
    }

    private JWSAlgorithm getAlgorithm(String algorithmName) throws BadJOSEException {
        switch (algorithmName) {
            case "RS256": {
                return JWSAlgorithm.RS256;
            }
            case "RS384": {
                return JWSAlgorithm.RS384;
            }
            case "RS512": {
                return JWSAlgorithm.RS512;
            }
        }
        throw new BadJOSEException("Unsupported algorithm: " + algorithmName);
    }

    private ConfigurableJWTProcessor<SecurityContext> getProcessor(HttpServletRequest request, JWSAlgorithm algorithm) {
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(algorithm, this.jwkSource);
        String requestPath = request.getRequestURL().toString();
        JWTClaimsSet exactMatchClaims = new JWTClaimsSet.Builder().audience(requestPath).build();
        DefaultJWTProcessor processor = new DefaultJWTProcessor();
        processor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("JWT")}));
        processor.setJWSKeySelector((JWSKeySelector)keySelector);
        processor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(exactMatchClaims, REQUIRED_CLAIMS));
        return processor;
    }

    public String getAuthMethod() {
        return "OAUTH";
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

