/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.oauth;

import app.utils.config.AppConfig;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAccessTokenFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAccessTokenFilter.class);
    private static final Set<String> REQUIRED_CLAIMS = Set.of("iss", "iat", "exp", "aud");
    private final JWKSource<SecurityContext> jwkSource;

    public JwtAccessTokenFilter() {
        try {
            URI uri = new URI(AppConfig.getInstance().getConfigs().getString("oauth.provider.jwks.endpoint"));
            URL url = uri.toURL();
            this.jwkSource = JWKSourceBuilder.create((URL)url).cache(true).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyJWTAccessToken(request, accessToken)) {
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        HttpServletResponse httpResp = (HttpServletResponse)response;
        httpResp.setHeader("WWW-Authenticate", "Bearer");
        httpResp.sendError(401, "Unauthorized");
    }

    private boolean verifyJWTAccessToken(HttpServletRequest request, String accessToken) {
        try {
            JWT decodedJwt = JWTParser.parse((String)accessToken);
            String algorithmName = decodedJwt.getHeader().getAlgorithm().toString();
            JWSAlgorithm algorithm = this.getAlgorithm(algorithmName);
            ConfigurableJWTProcessor<SecurityContext> processor = this.getProcessor(request, algorithm);
            processor.process(decodedJwt, null);
            LOG.debug("Access Token with algorithm {} is valid", (Object)algorithmName);
            return true;
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            LOG.error("Access Token is not valid", e);
        }
        catch (Exception e) {
            LOG.error("An unexpected error occurred during Access Token validation", (Throwable)e);
        }
        return false;
    }

    private JWSAlgorithm getAlgorithm(String algorithmName) throws BadJOSEException {
        switch (algorithmName) {
            case "RS256": {
                return JWSAlgorithm.RS256;
            }
            case "RS384": {
                return JWSAlgorithm.RS384;
            }
            case "RS512": {
                return JWSAlgorithm.RS512;
            }
        }
        throw new BadJOSEException("Unsupported algorithm: " + algorithmName);
    }

    private ConfigurableJWTProcessor<SecurityContext> getProcessor(HttpServletRequest request, JWSAlgorithm algorithm) {
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(algorithm, this.jwkSource);
        String requestPath = request.getRequestURL().toString();
        JWTClaimsSet exactMatchClaims = new JWTClaimsSet.Builder().audience(requestPath).build();
        DefaultJWTProcessor processor = new DefaultJWTProcessor();
        processor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("JWT")}));
        processor.setJWSKeySelector((JWSKeySelector)keySelector);
        processor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(exactMatchClaims, REQUIRED_CLAIMS));
        return processor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

