/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server.management.info;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.configuration2.CompositeConfiguration;

public class EnvInfo {
    private Map<String, Map<String, String>> masterKeyToKeysCache;
    private Map<String, String> keyToJsonAttributeCache;

    public void populateJson(ObjectNode json, CompositeConfiguration cfg) throws ServletException {
        this.masterKeyToKeysCache = new HashMap<String, Map<String, String>>();
        this.keyToJsonAttributeCache = new HashMap<String, String>();
        Iterator keys = cfg.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.regionMatches(true, 0, "info.", 0, "info.".length())) continue;
            String jsonAttributePath = this.getJsonAttributePath(key);
            String masterKey = String.format("info.%s", jsonAttributePath.toLowerCase(Locale.ROOT).replaceAll("[-_]", ""));
            this.populateJson(json, cfg, jsonAttributePath, key, masterKey);
        }
    }

    private String getJsonAttributePath(String key) {
        StringBuilder attributePath = new StringBuilder("");
        for (String attributeSubPath : this.getSanitizedKey(key).split("\\.")) {
            if (attributeSubPath.matches("[_]+")) continue;
            if (attributeSubPath.matches(".*\\$.*")) {
                attributeSubPath = this.getSanitizedAttributeSubPath(attributeSubPath);
            } else if ((attributeSubPath = attributeSubPath.replaceAll("^[-]", "")).matches("[_]+")) continue;
            if (attributeSubPath.isEmpty()) continue;
            attributePath.append(String.format(".%s", attributeSubPath));
        }
        if (attributePath.length() > 0) {
            attributePath.deleteCharAt(0);
        }
        return attributePath.toString();
    }

    private String getSanitizedKey(String key) {
        String sanitizedKey = key.replaceAll("\\.{2,}+", ".");
        sanitizedKey = key.substring("info.".length());
        sanitizedKey = sanitizedKey.replaceAll("[^a-zA-Z0-9._$-]+", "");
        return sanitizedKey;
    }

    private String getSanitizedAttributeSubPath(String attributeSubPath) {
        String[] sections = attributeSubPath.split("\\$");
        StringBuilder sanitizedAttributeSubPath = new StringBuilder();
        boolean validCharFound = false;
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i].matches("[_]+") && !validCharFound || !sections[i].matches("^[a-zA-Z0-9]+$") && (i <= 0 || !sections[i].contains("-"))) continue;
            sanitizedAttributeSubPath.append(sections[i]);
            validCharFound = true;
        }
        return sanitizedAttributeSubPath.toString();
    }

    private void populateJson(ObjectNode json, CompositeConfiguration cfg, String jsonAttributePath, String key, String masterKey) {
        String[] parts = jsonAttributePath.split("\\.", 2);
        boolean subPathAttributeExists = json.has(parts[0]);
        boolean subPathAttributeIsObject = false;
        if (subPathAttributeExists) {
            subPathAttributeIsObject = json.get(parts[0]) instanceof ObjectNode;
        }
        if (parts.length > 1) {
            ObjectNode childNode;
            if (!subPathAttributeExists) {
                childNode = json.objectNode();
                json.set(parts[0], (JsonNode)childNode);
            } else if (subPathAttributeIsObject) {
                childNode = (ObjectNode)json.get(parts[0]);
            } else {
                return;
            }
            this.populateJson(childNode, cfg, parts[1], key, masterKey);
            return;
        }
        if (parts[0].length() == 0 || subPathAttributeExists && subPathAttributeIsObject) {
            return;
        }
        this.insertTextAttributeIntoJson(json, cfg, parts[0], key, masterKey);
    }

    private void insertTextAttributeIntoJson(ObjectNode json, CompositeConfiguration cfg, String jsonAttribute, String key, String masterKey) {
        String value = cfg.getStringArray(key)[cfg.getStringArray(key).length - 1];
        if (!this.masterKeyToKeysCache.containsKey(masterKey)) {
            json.put(jsonAttribute, value);
            HashMap<String, String> keysToValue = new HashMap<String, String>();
            keysToValue.put(key, value);
            this.masterKeyToKeysCache.put(masterKey, keysToValue);
            this.keyToJsonAttributeCache.put(key, jsonAttribute);
            return;
        }
        if (key.equals(masterKey)) {
            json.put(jsonAttribute, value);
            for (String permutationKey : this.masterKeyToKeysCache.get(masterKey).keySet()) {
                String permutationKeyJsonAttribute = this.keyToJsonAttributeCache.get(permutationKey);
                json.put(permutationKeyJsonAttribute, value);
            }
            this.masterKeyToKeysCache.get(masterKey).put(key, value);
            this.keyToJsonAttributeCache.put(key, jsonAttribute);
        } else {
            boolean masterKeyIsInCache = this.masterKeyToKeysCache.get(masterKey).containsKey(masterKey);
            if (masterKeyIsInCache) {
                String masterKeyValue = this.masterKeyToKeysCache.get(masterKey).get(masterKey);
                json.put(jsonAttribute, masterKeyValue);
                this.masterKeyToKeysCache.get(masterKey).put(key, value);
                this.keyToJsonAttributeCache.put(key, jsonAttribute);
            } else {
                String valueInUseByOtherAttributes = this.masterKeyToKeysCache.get(masterKey).entrySet().iterator().next().getValue();
                this.masterKeyToKeysCache.get(masterKey).put(key, value);
                this.keyToJsonAttributeCache.put(key, jsonAttribute);
                if (valueInUseByOtherAttributes.equals(this.masterKeyToKeysCache.get(masterKey).entrySet().iterator().next().getValue())) {
                    json.put(jsonAttribute, valueInUseByOtherAttributes);
                } else {
                    for (String keyInCache : this.masterKeyToKeysCache.get(masterKey).keySet()) {
                        String keyInCacheAttribute = this.keyToJsonAttributeCache.get(keyInCache);
                        json.put(keyInCacheAttribute, value);
                    }
                }
            }
        }
    }
}

