/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.legacy.oidc;

import app.utils.security.server.legacy.oidc.AbstractOidcAccessTokenFilter;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.ServletException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;

@PreMatching
@Priority(value=1000)
public class OidcAccessTokenRSFilter
extends AbstractOidcAccessTokenFilter
implements ContainerRequestFilter {
    public OidcAccessTokenRSFilter(String validationEndpoint) {
        super(validationEndpoint);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authzHeader = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        try {
            super.filter(authzHeader, () -> this.authorize(), () -> this.unauthorize(requestContext));
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    private void authorize() throws IOException, ServletException {
    }

    private void unauthorize(ContainerRequestContext requestContext) throws IOException {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        builder.header("WWW-Authenticate", (Object)"Bearer");
        requestContext.abortWith(builder.build());
    }
}

