/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.legacy.oidc;

import app.utils.security.server.legacy.oidc.AbstractOidcAccessTokenFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OidcAccessTokenServletFilter
extends AbstractOidcAccessTokenFilter
implements Filter {
    public OidcAccessTokenServletFilter(String validationEndpoint) {
        super(validationEndpoint);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        super.filter(authzHeader, () -> this.authorize(req, res, chain), () -> this.unauthorize(res));
    }

    private void authorize(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(req, res);
    }

    private void unauthorize(ServletResponse res) throws IOException {
        HttpServletResponse httpResp = (HttpServletResponse)res;
        httpResp.setHeader("WWW-Authenticate", "Bearer");
        httpResp.sendError(401, "Unauthorized");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

