/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.oauth;

import app.utils.config.AppConfig;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PublicKey;
import java.util.List;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.filters.JwtAccessTokenValidator;

public class DynamicKeyJwtAccessTokenValidator
extends JwtAccessTokenValidator {
    private final JWKSource<SecurityContext> jwkSource;

    public DynamicKeyJwtAccessTokenValidator() {
        try {
            URI uri = new URI(AppConfig.getInstance().getConfigs().getString("oauth.provider.jwks.endpoint"));
            URL url = uri.toURL();
            this.jwkSource = JWKSourceBuilder.create((URL)url).cache(true).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwtToken jwt) {
        PublicKey publicKey = null;
        try {
            JWKMatcher keyMatcher = new JWKMatcher.Builder().keyID(jwt.getJwsHeaders().getKeyId()).build();
            JWKSelector keySelector = new JWKSelector(keyMatcher);
            List jwks = this.jwkSource.get(keySelector, null);
            if (jwks.isEmpty()) {
                throw new RuntimeException("Failed to find a matching public key for JWT verification. Key ID '" + jwt.getJwsHeaders().getKeyId() + "' does not correspond to any key in the JWK set retrieved from provider");
            }
            JWK jwk = (JWK)jwks.get(0);
            publicKey = jwk.toRSAKey().toPublicKey();
        }
        catch (KeySourceException e) {
            throw new RuntimeException("Unable to get Access Token signature Public Key from provider", e);
        }
        catch (JOSEException e) {
            throw new RuntimeException("Unable to convert Access Token signature Public Key from provider", e);
        }
        PublicKeyJwsSignatureVerifier signatureVerifier = new PublicKeyJwsSignatureVerifier(publicKey, jwt.getJwsHeaders().getSignatureAlgorithm());
        return signatureVerifier;
    }
}

