/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletMapping;

public class ManagementEndpointsHTTPHandler
extends JettyHTTPHandler {
    private final ServletContextHandler servletContext;
    private final List<String> allServletContextPaths;
    private final String mgmtEndpointPath;

    public ManagementEndpointsHTTPHandler(Bus cxfBus, ServletContextHandler servletContext, String mgmtContextPath) {
        super(cxfBus);
        this.servletContext = servletContext;
        this.allServletContextPaths = servletContext != null && servletContext.getServletHandler() != null && servletContext.getServletHandler().getServletMappings() != null ? this.extractPaths(servletContext.getServletHandler().getServletMappings()) : List.of();
        this.mgmtEndpointPath = mgmtContextPath.length() <= 1 && mgmtContextPath.endsWith("/") ? "" : mgmtContextPath;
    }

    private List<String> extractPaths(ServletMapping[] servletMappings) {
        ArrayList<String> result = new ArrayList<String>();
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs;
            for (String path : pathSpecs = mapping.getPathSpecs()) {
                if (path.endsWith("/*")) {
                    result.add(path.substring(0, path.length() - 2));
                    continue;
                }
                result.add(path);
            }
        }
        return result;
    }

    List<String> getAllServletContextPaths() {
        return this.allServletContextPaths;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.shouldHandle(target)) {
            target = String.format("%s%s", this.mgmtEndpointPath, target);
            this.servletContext.handle(target, baseRequest, request, response);
        }
    }

    private boolean shouldHandle(String target) {
        for (String endpointPath : this.getAllServletContextPaths()) {
            if (!target.startsWith(endpointPath)) continue;
            return true;
        }
        return false;
    }
}

