/*
 * Decompiled with CFR 0.152.
 */
package app.utils.config;

import app.utils.config.ServerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig {
    public static final String LIST_DELIMITER = ",";
    private static final Logger LOG = LoggerFactory.getLogger(AppConfig.class);
    private static AppConfig instance;
    private static String defaultSourceFileLocation;
    private static List<String> additionalFileLocations;
    private static Properties contextParamsOverride;
    private static String CLASSPATH_PREFIX;
    private static String SECURITY_USER_NAME_PROPERTY_NAME;
    private static String SECURITY_USER_NAME_DEFAULT_VALUE;
    private static String SECURITY_USER_PASSWORD_PROPERTY_NAME;
    private CompositeConfiguration configs = new CompositeConfiguration();
    private CompositeConfiguration additionalConfigs = new CompositeConfiguration();

    private AppConfig() throws ConfigurationException {
        SystemConfiguration sysConfigs = new SystemConfiguration();
        EnvironmentConfiguration envConfigs = new EnvironmentConfiguration();
        PropertiesConfiguration propsConfigs = new PropertiesConfiguration();
        this.configs.addConfiguration((org.apache.commons.configuration2.Configuration)sysConfigs);
        this.configs.addConfiguration((org.apache.commons.configuration2.Configuration)envConfigs);
        if (null != additionalFileLocations) {
            PropertiesConfiguration addtionalPropsConfigs = new PropertiesConfiguration();
            additionalFileLocations.forEach(addtionalSourceFileLocation -> {
                AppConfig.addConfigsFromFile(addtionalPropsConfigs, addtionalSourceFileLocation);
                AppConfig.addConfigsFromFile(propsConfigs, addtionalSourceFileLocation);
            });
            this.additionalConfigs.addConfiguration((org.apache.commons.configuration2.Configuration)addtionalPropsConfigs);
        }
        if (defaultSourceFileLocation != null) {
            AppConfig.addConfigsFromFile(propsConfigs, defaultSourceFileLocation);
        }
        AppConfig.reloadValuesFromEnv(propsConfigs);
        AppConfig.validateSecurityConfig(propsConfigs);
        AppConfig.checkForTaskExecutionId(propsConfigs);
        this.configs.addConfiguration((org.apache.commons.configuration2.Configuration)propsConfigs);
    }

    private static void checkForTaskExecutionId(PropertiesConfiguration config) {
        String taskExecutionId = config.getString("taskExecutionId");
        if (taskExecutionId != null && !taskExecutionId.isEmpty()) {
            System.setProperty("tmc.task.execution.id", taskExecutionId);
        }
    }

    protected static void reloadValuesFromEnv(PropertiesConfiguration propsConfigs) {
        HashMap<String, String> updProps = new HashMap<String, String>();
        Iterator keys = propsConfigs.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = propsConfigs.getString(key);
            if (value == null || !value.contains("${") || !value.contains("}")) continue;
            Matcher m = Pattern.compile("\\$\\{([^:]*)(\\:\\#\\{([^}]*)\\})?\\}").matcher(value);
            while (m.find()) {
                String envValue = "null".equalsIgnoreCase(m.group(3)) ? "" : m.group(3);
                value = value.replace(m.group(0), new EnvironmentConfiguration().getString(m.group(1), envValue));
            }
            updProps.put(key, value);
        }
        for (Map.Entry p : updProps.entrySet()) {
            propsConfigs.setProperty((String)p.getKey(), p.getValue());
        }
    }

    public static void addConfigsFromFile(PropertiesConfiguration propsConfigs, String sourceFileLocation) {
        block14: {
            try (InputStream resourceAsStream = AppConfig.getFileInputStream(sourceFileLocation);){
                if (resourceAsStream != null) {
                    try (InputStreamReader reader = new InputStreamReader(resourceAsStream);){
                        propsConfigs.read((Reader)reader);
                        break block14;
                    }
                }
                LOG.error("Failed to load configuration file " + sourceFileLocation);
            }
            catch (IOException | ConfigurationException e) {
                LOG.error("Failed to load configs from file " + sourceFileLocation, e);
            }
        }
    }

    public static InputStream getFileInputStream(String sourceFileLocation) {
        try {
            if (sourceFileLocation.startsWith(CLASSPATH_PREFIX)) {
                sourceFileLocation = AppConfig.removeLeadingFileSeparator(sourceFileLocation.substring(CLASSPATH_PREFIX.length()));
                return AppConfig.class.getClassLoader().getResourceAsStream(sourceFileLocation);
            }
            Path filePath = Path.of(sourceFileLocation, new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                return Files.newInputStream(filePath, new OpenOption[0]);
            }
            sourceFileLocation = AppConfig.removeLeadingFileSeparator(sourceFileLocation);
            return AppConfig.class.getClassLoader().getResourceAsStream(sourceFileLocation);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String removeLeadingFileSeparator(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private static void validateSecurityConfig(PropertiesConfiguration config) {
        String springSecurityUserNameValue = config.getString(SECURITY_USER_NAME_PROPERTY_NAME);
        String springSecurityUserPasswordValue = config.getString(SECURITY_USER_PASSWORD_PROPERTY_NAME);
        if (springSecurityUserNameValue != null && !springSecurityUserNameValue.isEmpty() && springSecurityUserPasswordValue != null && !springSecurityUserPasswordValue.isEmpty()) {
            LOG.info("microservice security username and password are available");
        } else {
            LOG.warn("microservice security username and password are NOT available, generating");
            springSecurityUserNameValue = SECURITY_USER_NAME_DEFAULT_VALUE;
            springSecurityUserPasswordValue = UUID.randomUUID().toString();
            config.setProperty(SECURITY_USER_NAME_PROPERTY_NAME, (Object)springSecurityUserNameValue);
            config.setProperty(SECURITY_USER_PASSWORD_PROPERTY_NAME, (Object)springSecurityUserPasswordValue);
            LOG.warn(String.format("%n%nUsing generated security credentials %nusername: %s %npassword: %s%n%nThis generated password is for development use only. %nYour security configuration must be updated before running your application in production.%n", springSecurityUserNameValue, springSecurityUserPasswordValue));
        }
    }

    public static void clearDefaultConfigFileLocation() {
        defaultSourceFileLocation = null;
    }

    public static void setAdditionalConfigFileLocation(String ... fileLocations) {
        if (fileLocations != null && fileLocations.length > 0) {
            additionalFileLocations = new ArrayList<String>();
            AppConfig.prioritizeAndAddFileLocations(fileLocations);
        } else {
            additionalFileLocations = null;
        }
    }

    public static void addAdditinalConfigFileLocation(String ... fileLocations) {
        if (fileLocations != null && fileLocations.length > 0) {
            if (null == additionalFileLocations) {
                additionalFileLocations = new ArrayList<String>();
            }
            AppConfig.prioritizeAndAddFileLocations(fileLocations);
        }
    }

    private static void prioritizeAndAddFileLocations(String ... fileLocations) {
        for (String fileLocation : fileLocations) {
            additionalFileLocations.add(0, fileLocation);
        }
    }

    public static void addContextParamProperty(Object key, Object value) {
        contextParamsOverride.remove(key);
        contextParamsOverride.put(key, value);
    }

    public static Properties getContextParamsOverride() {
        return contextParamsOverride;
    }

    public static AppConfig getInstance() {
        if (instance == null) {
            try {
                instance = new AppConfig();
                System.setProperty("log4j.configurationFile", AppConfig.getCfg().getString("logging.config", "config/log4j2.xml"));
                Configurator.reconfigure();
                Configurator.initialize((ClassLoader)AppConfig.class.getClassLoader(), (Configuration)null).reconfigure();
                ServerConfig.reload();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Failed to initialize AppConfig singleton instance", e);
            }
        }
        return instance;
    }

    public static void reload() {
        instance = null;
        AppConfig.getInstance();
    }

    public CompositeConfiguration getConfigs() {
        return this.configs;
    }

    public CompositeConfiguration getAdditionalConfigs() {
        return this.additionalConfigs;
    }

    public static CompositeConfiguration getCfg() {
        return AppConfig.getInstance().getConfigs();
    }

    public static CompositeConfiguration getAdditionalCfg() {
        return AppConfig.getInstance().getAdditionalConfigs();
    }

    public static int getInt(String name, int defaultValue) {
        try {
            return AppConfig.getCfg().getInt(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        try {
            return AppConfig.getCfg().getBoolean(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String name) {
        return AppConfig.getCfg().getString(name);
    }

    public static String getString(String name, String defaultValue) {
        return AppConfig.getCfg().getString(name, defaultValue);
    }

    public static String getNonEmptyString(String name, String defaultValue) {
        String result = AppConfig.getCfg().getString(name, defaultValue);
        return result.length() == 0 ? defaultValue : result;
    }

    static {
        defaultSourceFileLocation = "config/application.properties";
        additionalFileLocations = new ArrayList<String>();
        contextParamsOverride = new Properties();
        CLASSPATH_PREFIX = "classpath:";
        SECURITY_USER_NAME_PROPERTY_NAME = "security.user.name";
        SECURITY_USER_NAME_DEFAULT_VALUE = "user";
        SECURITY_USER_PASSWORD_PROPERTY_NAME = "security.user.password";
    }
}

