/*
 * Decompiled with CFR 0.152.
 */
package app.utils.config;

import app.utils.config.AppConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineConfigHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineConfigHandler.class);
    private static final String CONTEXT_PARAM = "<key>=<value>";
    private static final String CONTEXT = "context";
    private static final String STAT_PORT = "stat.port";
    private static final String PID = "pid";
    private static final String CONFIG_ADDITIONAL_LOCATION = "config.additional-location";
    private static final String CBP_AGENT_CONFIG_LOCATION = "cbp.agent.config-location";
    private static final String SPRING_CONFIG_ADDITIONAL_LOCATION = "spring.config.additional-location";
    private static final String SERVER_PORT = "server.port";
    private static final String MANAGEMENT_ENDPOINTS_SECURED = "management.endpoints.secured";
    private static final String SECURITY_USER_NAME = "security.user.name";
    private static final String SECURITY_USER_PASSWORD = "security.user.password";
    private static final String MANAGEMENT_SERVER_BASE_PATH = "management.server.base-path";
    private static final String MANAGEMENT_ENDPOINTS_WEB_EXPOSURE_INCLUDE = "management.endpoints.web.exposure.include";
    private static final String LOGGING_CONFIG = "logging.config";
    private static final String BANNER = "banner";

    public static void parseCmdLineAndPrintBanner(String[] args) {
        Option help = Option.builder((String)"h").longOpt("help").desc("print this message").build();
        Option contextParam = Option.builder().longOpt(CONTEXT_PARAM).desc(String.format("To override a context parameter or a property", new Object[0])).build();
        Option context = Option.builder().longOpt(CONTEXT).desc("To set the context name").hasArg().build();
        Option statPort = Option.builder().longOpt(STAT_PORT).desc("To set statistic port number").hasArg().build();
        Option pid = Option.builder().longOpt(PID).desc("To force pid of the job").hasArg().build();
        Option configAdditionalLoc = Option.builder().longOpt(CONFIG_ADDITIONAL_LOCATION).desc("To set the additional configuration files to read, separated by ','").hasArgs().valueSeparator(',').build();
        Option cbpAgentConfigLoc = Option.builder().longOpt(CBP_AGENT_CONFIG_LOCATION).desc("File location of CBP agent config file, separated by ','").hasArgs().valueSeparator(',').build();
        Option configAdditionalLocLegacy = Option.builder().longOpt(SPRING_CONFIG_ADDITIONAL_LOCATION).desc(String.format("Alias for %s. To set the additional configuration files to read, separated by ','", CONFIG_ADDITIONAL_LOCATION)).hasArgs().valueSeparator(',').build();
        Option serverPort = Option.builder().longOpt(SERVER_PORT).desc("The port on which the server will listen").hasArgs().build();
        Option managementEndpointsSecured = Option.builder().longOpt(MANAGEMENT_ENDPOINTS_SECURED).desc("Disable security for the mannagement endpoints").hasArgs().build();
        Option securityUserName = Option.builder().longOpt(SECURITY_USER_NAME).desc("Security user name for management endpoints").hasArgs().build();
        Option securityUserPassword = Option.builder().longOpt(SECURITY_USER_PASSWORD).desc("Security user password for management endpoints").hasArgs().build();
        Option managementServerBasePath = Option.builder().longOpt(MANAGEMENT_SERVER_BASE_PATH).desc("Management server base path").hasArgs().build();
        Option managementEndpointsWebExposureInclude = Option.builder().longOpt(MANAGEMENT_ENDPOINTS_WEB_EXPOSURE_INCLUDE).desc("Management server base path").hasArgs().build();
        Option loggingConfig = Option.builder().longOpt(LOGGING_CONFIG).desc("Location of the logging configuration file").hasArgs().build();
        Option banner = Option.builder().longOpt(BANNER).desc("To set the location of the banner file").hasArg().build();
        Options helpOptions = new Options();
        helpOptions.addOption(help).addOption(contextParam).addOption(context).addOption(statPort).addOption(pid).addOption(configAdditionalLoc).addOption(cbpAgentConfigLoc).addOption(serverPort).addOption(securityUserName).addOption(securityUserPassword).addOption(managementEndpointsSecured).addOption(managementServerBasePath).addOption(managementEndpointsWebExposureInclude).addOption(loggingConfig).addOption(banner);
        Options allOptions = new Options();
        for (Option op : helpOptions.getOptions()) {
            allOptions.addOption(op);
        }
        allOptions.addOption(configAdditionalLocLegacy);
        allOptions.addOption(cbpAgentConfigLoc);
        final ArrayList extraArgs = new ArrayList();
        DefaultParser parser = new DefaultParser(){

            public CommandLine parse(Options options, String[] arguments) throws ParseException {
                if (null == arguments) {
                    return new CommandLine.Builder().build();
                }
                ArrayList<String> knownArgs = new ArrayList<String>();
                for (int i = 0; i < arguments.length; ++i) {
                    String a = arguments[i];
                    if (a.contains("=")) {
                        String aName = a.split("=")[0];
                        if (options.hasOption(aName)) {
                            knownArgs.add(a);
                            continue;
                        }
                        extraArgs.add(a);
                        continue;
                    }
                    if (options.hasOption(a)) {
                        knownArgs.add(a);
                        if (i + 1 >= arguments.length || !options.getOption(a).hasArg()) continue;
                        knownArgs.add(arguments[i + 1]);
                        continue;
                    }
                    extraArgs.add(a);
                }
                return super.parse(options, knownArgs.toArray(new String[0]));
            }
        };
        HelpFormatter helper = new HelpFormatter();
        helper.setSyntaxPrefix("Usage: ");
        helper.setLongOptSeparator("=");
        helper.setWidth(300);
        try {
            CharSequence[] configFiles;
            CommandLine cmd = parser.parse(allOptions, args);
            if (cmd.hasOption(help)) {
                helper.printHelp(" ", helpOptions);
                CommandLineConfigHandler.killJVM();
            }
            if (cmd.hasOption(configAdditionalLoc)) {
                configFiles = cmd.getOptionValues(configAdditionalLoc);
                AppConfig.addAdditinalConfigFileLocation((String[])configFiles);
                System.setProperty(CONFIG_ADDITIONAL_LOCATION, String.join((CharSequence)",", configFiles));
            }
            if (cmd.hasOption(cbpAgentConfigLoc)) {
                String configFile = cmd.getOptionValue(cbpAgentConfigLoc);
                System.setProperty("cbp.agent.config", configFile);
            }
            if (cmd.hasOption(configAdditionalLocLegacy)) {
                configFiles = cmd.getOptionValues(configAdditionalLocLegacy);
                AppConfig.addAdditinalConfigFileLocation((String[])configFiles);
                System.setProperty(SPRING_CONFIG_ADDITIONAL_LOCATION, String.join((CharSequence)",", configFiles));
            }
            if (cmd.hasOption(serverPort)) {
                System.setProperty(SERVER_PORT, cmd.getOptionValue(serverPort));
            }
            if (cmd.hasOption(securityUserName)) {
                System.setProperty(SECURITY_USER_NAME, cmd.getOptionValue(securityUserName));
            }
            if (cmd.hasOption(securityUserPassword)) {
                System.setProperty(SECURITY_USER_PASSWORD, cmd.getOptionValue(securityUserPassword));
            }
            if (cmd.hasOption(managementEndpointsSecured)) {
                System.setProperty(MANAGEMENT_ENDPOINTS_SECURED, cmd.getOptionValue(managementEndpointsSecured));
            }
            if (cmd.hasOption(managementServerBasePath)) {
                System.setProperty(MANAGEMENT_SERVER_BASE_PATH, cmd.getOptionValue(managementServerBasePath));
            }
            if (cmd.hasOption(managementEndpointsWebExposureInclude)) {
                System.setProperty(MANAGEMENT_ENDPOINTS_WEB_EXPOSURE_INCLUDE, cmd.getOptionValue(managementEndpointsWebExposureInclude));
            }
            if (cmd.hasOption(loggingConfig)) {
                System.setProperty(LOGGING_CONFIG, cmd.getOptionValue(loggingConfig));
            }
            if (cmd.hasOption(context)) {
                System.setProperty(CONTEXT, cmd.getOptionValue(context));
            }
            if (cmd.hasOption(contextParam)) {
                AppConfig.addContextParamProperty(cmd.getOptionValues(contextParam)[0], cmd.getOptionValues(contextParam)[1]);
            }
            if (cmd.hasOption(banner)) {
                System.setProperty("banner.location", cmd.getOptionValue(banner));
            }
            if (cmd.hasOption(pid)) {
                System.setProperty(PID, cmd.getOptionValue(pid));
            }
            if (cmd.hasOption(statPort)) {
                System.setProperty("stat_port", cmd.getOptionValue(statPort));
            }
            for (String arg : extraArgs) {
                if (!arg.contains("=") || !arg.startsWith("--")) continue;
                arg = arg.replaceFirst("--", "");
                String[] param = arg.split("=", 2);
                AppConfig.addContextParamProperty(param[0], param[1]);
            }
            AppConfig.reload();
            CommandLineConfigHandler.printBanner();
        }
        catch (ParseException e) {
            helper.printHelp(" ", helpOptions);
            throw new RuntimeException(e);
        }
    }

    static void killJVM() {
        System.exit(0);
    }

    private static void printBanner() {
        block16: {
            String bannerFileLocation = AppConfig.getNonEmptyString("banner.location", "config/banner.txt");
            try (InputStream resourceAsStream = AppConfig.getFileInputStream(bannerFileLocation);){
                if (resourceAsStream != null) {
                    try (Scanner scanner = new Scanner(resourceAsStream).useDelimiter("\\A");){
                        if (scanner.hasNext()) {
                            System.out.println(scanner.next());
                        }
                        break block16;
                    }
                }
                LOG.error("Failed to load banner file " + bannerFileLocation);
            }
            catch (IOException e) {
                LOG.error("Error while reading banner file ", (Object)e.getMessage());
            }
        }
    }
}

