/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.basic;

import app.utils.config.AppConfig;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;

public class BasicHttpAuthFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String authorizationHeader = req.getHeader("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            this.unauthorize(response);
            return;
        }
        String base64Credentials = authorizationHeader.substring("Basic".length()).trim();
        String credentials = new String(Base64.getDecoder().decode(base64Credentials));
        String[] values = credentials.split(":", 2);
        String username = values[0];
        String password = values[1];
        if (!AppConfig.getString("security.user.name").equals(username) || !AppConfig.getString("security.user.password").equals(password)) {
            this.unauthorize(response);
        }
        chain.doFilter(request, response);
    }

    private void unauthorize(ServletResponse res) throws IOException {
        HttpServletResponse httpResp = (HttpServletResponse)res;
        httpResp.setHeader("WWW-Authenticate", "basic realm=\"TalendRealm\"");
        httpResp.sendError(401, "Unauthorized");
    }
}

