/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.client;

import app.utils.security.client.AppClientAuth;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class AsyncClientInterceptor
extends AbstractPhaseInterceptor<Message> {
    AppClientAuth.GetAuthHeaderFun getAuthHeaderFun;

    public AsyncClientInterceptor(AppClientAuth.GetAuthHeaderFun getAuthHeaderFun) {
        super("post-protocol");
        this.getAuthHeaderFun = getAuthHeaderFun;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isRequestor(message)) {
            Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
            try {
                String authorizationHeader = this.getAuthHeaderFun.generate();
                headers.put("Authorization", Collections.singletonList(authorizationHeader));
            }
            catch (RuntimeException ex) {
                throw new Fault((Throwable)ex);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
            }
        }
    }
}

