/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletResourceManager
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServletResourceManager.class);
    private List<AutoCloseable> resourcesToClose;

    public ServletResourceManager(AutoCloseable ... resource) {
        this.resourcesToClose = List.of(resource);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.resourcesToClose != null) {
            for (AutoCloseable resource : this.resourcesToClose) {
                if (resource == null) continue;
                try {
                    resource.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close resource: " + resource.getClass().getName(), (Throwable)e);
                }
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
    }
}

