/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.config.AppConfig;
import app.utils.config.ServerConfig;
import app.utils.security.server.basic.BasicHttpAuthFilter;
import app.utils.security.server.legacy.oidc.OidcAccessTokenRSFilter;
import app.utils.security.server.legacy.oidc.OidcAccessTokenServletFilter;
import app.utils.server.LivenessServlet;
import app.utils.server.ManagementEndpointsHTTPHandler;
import app.utils.server.ReadinessServlet;
import app.utils.server.ServletResourceManager;
import app.utils.server.ShutdownServlet;
import app.utils.server.management.info.InfoServlet;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.system.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.servlet.jakarta.exporter.MetricsServlet;
import io.prometheus.jmx.BuildInfoCollector;
import io.prometheus.jmx.JmxCollector;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.jaxrs.provider.dom4j.DOM4JProvider;
import org.apache.cxf.jaxrs.security.JAASAuthenticationFilter;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.cxf.metrics.MetricsFeature;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.codahale.CodahaleMetricsProvider;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jolokia.server.core.http.AgentServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppJetty {
    private static final Logger LOG = LoggerFactory.getLogger(AppJetty.class);

    @Deprecated
    public static Server createServer() {
        int webPort = ServerConfig.getPort();
        return new Server(webPort);
    }

    @Deprecated
    public static void addCxfJaxRSServlet(ServletContextHandler servletContext, String applicationClassName) {
        ServletHolder cxfServletHolder = new ServletHolder((Servlet)new CXFNonSpringJaxrsServlet());
        cxfServletHolder.setInitParameter("jaxrs.serviceClasses", applicationClassName);
        cxfServletHolder.setInitParameter("jaxrs.providers", DOM4JProvider.class.getName());
        servletContext.addServlet(cxfServletHolder, ServerConfig.getServletContextPath() + "/*");
    }

    public static JettyHTTPServerEngine createServer(Bus cxfBus) {
        JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)cxfBus.getExtension(JettyHTTPServerEngineFactory.class);
        if (HttpScheme.HTTPS.toString().equalsIgnoreCase(ServerConfig.getProtocol())) {
            TLSServerParameters params = ServerConfig.getTLSConfig();
            try {
                serverEngineFactory.setTLSServerParametersForPort(ServerConfig.getHost(), ServerConfig.getPort(), params);
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error(String.format("Setting SSL/TLS for port %d resulted in exception, startup errors may occur", ServerConfig.getPort()), (Throwable)e);
            }
        }
        try {
            return serverEngineFactory.createJettyHTTPServerEngine(ServerConfig.getHost(), ServerConfig.getPort(), ServerConfig.getProtocol());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(String.format("Creatng Jetty server at %s://%s:%s resulted in exception", ServerConfig.getProtocol(), ServerConfig.getHost(), ServerConfig.getPort()), e);
        }
    }

    public static void startServer(Bus cxfBus, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext) {
        ManagementEndpointsHTTPHandler jettyHttpHandler = new ManagementEndpointsHTTPHandler(cxfBus, servletContext, ServerConfig.getMgmtContextPath());
        try {
            URL mgmtUrl = new URL(ServerConfig.getMgmtEndpointsPrefix());
            serverEngine.addServant(mgmtUrl, (JettyHTTPHandler)jettyHttpHandler);
            servletContext.setServer(serverEngine.getServer());
            serverEngine.getServer().addManaged((LifeCycle)servletContext);
        }
        catch (MalformedURLException e) {
            LOG.error(String.format("Converting %s to URL resulted in exception - management endpoints will not be available", ServerConfig.getMgmtEndpointsPrefix()), (Throwable)e);
        }
    }

    public static void addMgmtEndpoints(JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        AppJetty.addMgmtServlets(null, serverEngine, servletContext, includePrometheus);
    }

    public static void addMgmtEndpoints(CamelContext camelContext, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        AppJetty.addMgmtServlets(camelContext, serverEngine, servletContext, includePrometheus);
    }

    protected static void addMgmtServlets(CamelContext camelContext, JettyHTTPServerEngine serverEngine, ServletContextHandler servletContext, boolean includePrometheus) {
        boolean addAuth = AppConfig.getBoolean("management.endpoints.secured", true);
        for (String endpointToAdd : ServerConfig.getMgmtEndpointsToAdd()) {
            if ("jolokia".equals(endpointToAdd)) {
                AppJetty.addJolokiaServlet(servletContext);
                continue;
            }
            if (includePrometheus && "prometheus".equals(endpointToAdd)) {
                AppJetty.addPrometheusServlet(servletContext, addAuth);
                continue;
            }
            if ("health".equals(endpointToAdd)) {
                AppJetty.addServlet(servletContext, new LivenessServlet(camelContext), "health", addAuth);
                AppJetty.addServlet(servletContext, new ReadinessServlet(camelContext), "ready", addAuth);
                continue;
            }
            if ("info".equals(endpointToAdd)) {
                AppJetty.addServlet(servletContext, new InfoServlet(camelContext), "info", addAuth);
                continue;
            }
            if (!"shutdown".equals(endpointToAdd)) continue;
            AppJetty.addServlet(servletContext, new ShutdownServlet(camelContext, serverEngine), "shutdown", true);
        }
    }

    public static void addJolokiaServlet(ServletContextHandler servletContext) {
        ServletHolder jolokiaServlet = new ServletHolder("jolokia", AgentServlet.class);
        String suffix = String.format("/%s/*", "jolokia");
        servletContext.addServlet(jolokiaServlet, suffix);
        AppJetty.addBasicAuthentication(servletContext, suffix);
    }

    public static void addPrometheusServlet(ServletContextHandler servletContext, boolean addAuth) {
        CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
        PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT, collectorRegistry, Clock.SYSTEM);
        new UptimeMetrics().bindTo((MeterRegistry)meterRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)meterRegistry);
        new DiskSpaceMetrics(new File(".")).bindTo((MeterRegistry)meterRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
        jvmGcMetrics.bindTo((MeterRegistry)meterRegistry);
        JvmHeapPressureMetrics jvmHeapPressureMetrics = new JvmHeapPressureMetrics();
        jvmHeapPressureMetrics.bindTo((MeterRegistry)meterRegistry);
        Log4j2Metrics log4j2Metrics = new Log4j2Metrics();
        log4j2Metrics.bindTo((MeterRegistry)meterRegistry);
        new JettyConnectionMetrics((MeterRegistry)meterRegistry);
        new JettySslHandshakeMetrics((MeterRegistry)meterRegistry);
        new BuildInfoCollector().register(collectorRegistry);
        String sourceFileLocation = "config/jmx-prometheus.yaml";
        try (InputStream resourceAsStream = AppJetty.class.getClassLoader().getResourceAsStream(sourceFileLocation);){
            if (resourceAsStream != null) {
                new JmxCollector(resourceAsStream).register(collectorRegistry);
            } else {
                LOG.error("Failed to load file " + sourceFileLocation + ", Prometheus JMX metrics collector will not be registered");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize Prometheus JMX metrics collector", (Throwable)e);
        }
        ServletResourceManager resourceManager = new ServletResourceManager(new AutoCloseable[]{jvmGcMetrics, jvmHeapPressureMetrics, log4j2Metrics});
        servletContext.addEventListener((EventListener)((Object)resourceManager));
        ServletHolder prometheusServlet = new ServletHolder("prometheus", (Servlet)new MetricsServlet(meterRegistry.getPrometheusRegistry()));
        String suffix = String.format("/%s", "prometheus");
        servletContext.addServlet(prometheusServlet, suffix);
        if (addAuth) {
            AppJetty.addBasicAuthentication(servletContext, suffix);
        }
    }

    public static void addServlet(ServletContextHandler servletContext, HttpServlet servlet, String mgmtEndpoint, boolean addAuth) {
        ServletHolder mgmtServlet = new ServletHolder((Servlet)servlet);
        String suffix = String.format("/%s", mgmtEndpoint);
        servletContext.addServlet(mgmtServlet, suffix);
        if (addAuth) {
            AppJetty.addBasicAuthentication(servletContext, suffix);
        }
    }

    public static void addJmxManagement(Bus cxfBus) {
        CodahaleMetricsProvider provider = new CodahaleMetricsProvider(cxfBus);
        MetricsFeature metricsFeature = new MetricsFeature((MetricsProvider)provider);
        cxfBus.getFeatures().add(metricsFeature);
    }

    public static void addCrossOriginFilter(ServletContextHandler servletContext) {
        FilterHolder holder = new FilterHolder(CrossOriginFilter.class);
        holder.setName("cross-origin");
        servletContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addBasicAuthentication(ServletContextHandler servletContext, String constraintPath) {
        BasicHttpAuthFilter filter = new BasicHttpAuthFilter();
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.FORWARD));
    }

    public static void addLegacyOIDCViaFilter(ServletContextHandler servletContext, String constraintPath) {
        OidcAccessTokenServletFilter filter = new OidcAccessTokenServletFilter(AppConfig.getString("validation.endpoint"));
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.FORWARD));
    }

    public static JAASAuthenticationFilter getBasicAuthRSProvider() {
        JAASAuthenticationFilter jaas = new JAASAuthenticationFilter();
        jaas.setContextName("jetty");
        Configuration jaasConfig = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry("app.utils.security.server.basic.JaasBasicAuthLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap())};
            }
        };
        jaas.setLoginConfig(jaasConfig);
        return jaas;
    }

    public static OidcAccessTokenRSFilter getLegacyOIDCAuthRSProvider() {
        return new OidcAccessTokenRSFilter(AppConfig.getString("validation.endpoint"));
    }

    public static String processAddress(String url) {
        String address = url;
        try {
            int port;
            Bus cxfBus;
            JettyHTTPServerEngineFactory serverEngineFactory;
            JettyHTTPServerEngine ref;
            URIBuilder uriBuilder = new URIBuilder(url);
            String protocol = ServerConfig.getProtocol();
            uriBuilder.setScheme(protocol);
            address = uriBuilder.build().toString();
            if (HttpScheme.HTTPS.toString().equalsIgnoreCase(protocol) && (null == (ref = (serverEngineFactory = (JettyHTTPServerEngineFactory)(cxfBus = BusFactory.getDefaultBus((boolean)true)).getExtension(JettyHTTPServerEngineFactory.class)).retrieveJettyHTTPServerEngine(port = uriBuilder.getPort())) || null != ref && null == ref.getTlsServerParameters())) {
                TLSServerParameters params = ServerConfig.getTLSConfig();
                serverEngineFactory.setTLSServerParametersForPort(port, params);
            }
        }
        catch (URISyntaxException e) {
            LOG.error(String.format("Failed to create URI from %s, SSL/TLS support won't be added and startup errors may occur", url), (Throwable)e);
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.error(String.format("Setting SSL/TLS for %s resulted in exception, startup errors may occur", url), (Throwable)e);
        }
        return address;
    }

    @Deprecated
    public static void addSSLSupport(Server server) {
        if (AppConfig.getBoolean("security.require-ssl", false)) {
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.setSecureScheme("https");
            https_config.setSecurePort(ServerConfig.getPort());
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            https_config.addCustomizer((HttpConfiguration.Customizer)src);
            File keystoreFile = Paths.get(AppConfig.getString("server.ssl.key-store"), new String[0]).toFile();
            if (!keystoreFile.exists()) {
                throw new RuntimeException("Could not setup keystore {} file not found" + keystoreFile.getAbsolutePath());
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(AppConfig.getString("server.ssl.key-store-password"));
            sslContextFactory.setKeyStoreType(AppConfig.getString("server.ssl.key-store-type"));
            sslContextFactory.setCertAlias(AppConfig.getString("server.ssl.key-store-alias"));
            try {
                sslContextFactory.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
            https.setPort(ServerConfig.getPort());
            https.setHost(ServerConfig.getHost());
            server.setConnectors(new Connector[]{https});
        }
    }

    @Deprecated
    public static SSLContextParameters buildSSLContext() {
        if (AppConfig.getBoolean("security.require-ssl", false)) {
            KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
            keyStoreParameters.setResource(AppConfig.getString("server.ssl.key-store"));
            keyStoreParameters.setPassword(AppConfig.getString("server.ssl.key-store-password"));
            KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
            keyManagersParameters.setKeyStore(keyStoreParameters);
            SSLContextParameters sslContextParameters = new SSLContextParameters();
            sslContextParameters.setKeyManagers(keyManagersParameters);
            sslContextParameters.setCertAlias(AppConfig.getString("server.ssl.key-store-alias"));
            return sslContextParameters;
        }
        return null;
    }

    public static void generateUserNameAndPassword() {
        String currentPassword;
        String currentUser = AppConfig.getString("security.user.name");
        boolean doReload = false;
        if (StringUtils.isEmpty((CharSequence)currentUser)) {
            currentUser = "user";
            System.setProperty("security.user.name", currentUser);
            doReload = true;
            LOG.warn("username is not available, generating");
        }
        if (StringUtils.isEmpty((CharSequence)(currentPassword = AppConfig.getString("security.user.password")))) {
            currentPassword = UUID.randomUUID().toString();
            System.setProperty("security.user.password", currentPassword);
            doReload = true;
            LOG.warn("password is not available, generating");
            LOG.warn(String.format("%n%nUsing generated security credentials %nusername: %s %npassword: %s%n%nThis generated password is for development use only. %nYour security configuration must be updated before running your application in production.%n", currentUser, currentPassword));
        }
        if (doReload) {
            AppConfig.reload();
        }
    }
}

