/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletMapping;

public class ManagementEndpointsHTTPHandler
extends JettyHTTPHandler {
    private final ServletContextHandler servletContext;
    private final List<String> allServletContextPaths;
    private final String mgmtEndpointPath;

    public ManagementEndpointsHTTPHandler(Bus cxfBus, ServletContextHandler servletContext, String mgmtContextPath) {
        super(cxfBus);
        this.servletContext = servletContext;
        this.allServletContextPaths = servletContext != null && servletContext.getServletHandler() != null && servletContext.getServletHandler().getServletMappings() != null ? this.extractPaths(servletContext.getServletHandler().getServletMappings()) : List.of();
        this.mgmtEndpointPath = mgmtContextPath.length() <= 1 && mgmtContextPath.endsWith("/") ? "" : mgmtContextPath;
    }

    private List<String> extractPaths(ServletMapping[] servletMappings) {
        ArrayList<String> result = new ArrayList<String>();
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs;
            for (String path : pathSpecs = mapping.getPathSpecs()) {
                if (path.endsWith("/*")) {
                    result.add(path.substring(0, path.length() - 2));
                    continue;
                }
                result.add(path);
            }
        }
        return result;
    }

    List<String> getAllServletContextPaths() {
        return this.allServletContextPaths;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target = ServletContextRequest.getServletContextRequest((ServletRequest)request).getDecodedPathInContext();
        if (this.shouldHandle(target)) {
            this.servletContext.getServletContext().getRequestDispatcher(target).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean shouldHandle(String target) {
        for (String endpointPath : this.getAllServletContextPaths()) {
            if (!target.startsWith(endpointPath)) continue;
            return true;
        }
        return false;
    }
}

