/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.config.ServerConfig;
import app.utils.server.AppServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownServlet
extends AppServlet {
    private final JettyHTTPServerEngine serverEngine;
    private static Logger LOG = LoggerFactory.getLogger(ShutdownServlet.class);

    public ShutdownServlet(CamelContext context, JettyHTTPServerEngine serverEngine) {
        super(context);
        this.serverEngine = serverEngine;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExecutorService service = Executors.newSingleThreadExecutor();
        if (null != this.serverEngine) {
            service.submit(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted");
                    Thread.interrupted();
                }
                if (null != this.getCamelContext()) {
                    LOG.info("Shutting down Camel routes, bye...");
                    this.getCamelContext().shutdown();
                }
                LOG.info("Shutting down management endpoints, bye...");
                try {
                    URL mgmtUrl = new URL(ServerConfig.getMgmtEndpointsPrefix());
                    this.serverEngine.removeServant(mgmtUrl);
                }
                catch (MalformedURLException e) {
                    LOG.warn(String.format("Converting %s to URL resulted in exception - management endpoints won't shut down as expected", ServerConfig.getMgmtEndpointsPrefix()), (Throwable)e);
                }
                this.serverEngine.shutdown();
                Bus cxfBus = BusFactory.getDefaultBus((boolean)false);
                if (null != cxfBus) {
                    LOG.info("Shutting down remaining cxf endpoints, bye...");
                    cxfBus.shutdown(true);
                }
            });
        }
        service.shutdown();
        response.setStatus(200);
    }
}

