/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;

public class VisualTotalsFunDef
extends FunDefBase {
    static final Resolver Resolver = new ReflectiveMultiResolver("VisualTotals", "VisualTotals(<Set>[, <Pattern>])", "Dynamically totals child members specified in a set using a pattern for the total label in the result set.", new String[]{"fxx", "fxxS"}, VisualTotalsFunDef.class);

    public VisualTotalsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        SetType setType;
        Type elementType;
        Exp validatedArg = super.validateArg(validator, args, i, category);
        if (i == 0 && !((elementType = (setType = (SetType)validatedArg.getType()).getElementType()) instanceof MemberType)) {
            throw MondrianResource.instance().VisualTotalsAppliedToTuples.ex();
        }
        return validatedArg;
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        StringCalc stringCalc = call.getArgCount() > 1 ? compiler.compileString(call.getArg(1)) : null;
        return new CalcImpl(call, listCalc, stringCalc);
    }

    static String substitute(String namePattern, String name) {
        StringBuilder buf = new StringBuilder(256);
        int namePatternLen = namePattern.length();
        int startIndex = 0;
        while (true) {
            int endIndex;
            if ((endIndex = namePattern.indexOf(42, startIndex)) == -1) break;
            if (++endIndex < namePatternLen && namePattern.charAt(endIndex) == '*') {
                buf.append(namePattern.substring(startIndex, endIndex));
            } else {
                buf.append(namePattern.substring(startIndex, endIndex - 1));
                buf.append(name);
            }
            startIndex = ++endIndex;
        }
        buf.append(namePattern.substring(startIndex));
        return buf.toString();
    }

    private static class VisualTotalMember
    extends RolapMember {
        private final Member member;
        private final Exp exp;

        VisualTotalMember(Member member, String name, Exp exp) {
            super((RolapMember)member.getParentMember(), (RolapLevel)member.getLevel(), null, name, Member.MemberType.FORMULA);
            this.member = member;
            this.exp = exp;
        }

        public boolean isCalculated() {
            return true;
        }

        public int getSolveOrder() {
            return 99;
        }

        public Exp getExpression() {
            return this.exp;
        }

        public int getOrdinal() {
            throw new UnsupportedOperationException();
        }

        public Member getDataMember() {
            return this.member;
        }

        public OlapElement lookupChild(SchemaReader schemaReader, String s) {
            throw new UnsupportedOperationException();
        }

        public OlapElement lookupChild(SchemaReader schemaReader, String s, MatchType matchType) {
            throw new UnsupportedOperationException();
        }

        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final StringCalc stringCalc;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, StringCalc stringCalc) {
            super(call, new Calc[]{listCalc, stringCalc});
            this.listCalc = listCalc;
            this.stringCalc = stringCalc;
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            ArrayList<Member> resultList = new ArrayList<Member>(list);
            int memberCount = list.size();
            for (int i = memberCount - 1; i >= 0; --i) {
                Member nextMember;
                Member member = (Member)list.get(i);
                if (i + 1 >= memberCount || (nextMember = (Member)resultList.get(i + 1)) == member || !nextMember.isChildOrEqualTo(member)) continue;
                resultList.set(i, this.createMember(member, i, resultList, evaluator));
            }
            return resultList;
        }

        private VisualTotalMember createMember(Member member, int i, List<Member> list, Evaluator evaluator) {
            String name;
            if (this.stringCalc != null) {
                String namePattern = this.stringCalc.evaluateString(evaluator);
                name = VisualTotalsFunDef.substitute(namePattern, member.getName());
            } else {
                name = member.getName();
            }
            List<Member> childMemberList = this.followingDescendants(member, i + 1, list);
            Exp exp = this.makeExpr(childMemberList);
            Validator validator = evaluator.getQuery().createValidator();
            Exp validatedExp = exp.accept(validator);
            return new VisualTotalMember(member, name, validatedExp);
        }

        private List<Member> followingDescendants(Member member, int i, List<Member> list) {
            Member descendant;
            ArrayList<Member> childMemberList = new ArrayList<Member>();
            while (i < list.size() && (descendant = list.get(i)) != member && descendant.isChildOrEqualTo(member)) {
                if (descendant instanceof VisualTotalMember) {
                    VisualTotalMember visualTotalMember = (VisualTotalMember)descendant;
                    childMemberList.add(visualTotalMember);
                    i = this.lastChildIndex(visualTotalMember.member, i, list);
                    continue;
                }
                childMemberList.add(descendant);
                ++i;
            }
            return childMemberList;
        }

        private int lastChildIndex(Member member, int start, List list) {
            Member descendant;
            int i = start;
            while (++i < list.size() && (descendant = (Member)list.get(i)) != member && descendant.isChildOrEqualTo(member)) {
            }
            return i;
        }

        private Exp makeExpr(List childMemberList) {
            Exp[] memberExprs = new Exp[childMemberList.size()];
            for (int i = 0; i < childMemberList.size(); ++i) {
                Member childMember = (Member)childMemberList.get(i);
                memberExprs[i] = new MemberExpr(childMember);
            }
            return new UnresolvedFunCall("Aggregate", new Exp[]{new UnresolvedFunCall("{}", Syntax.Braces, memberExprs)});
        }
    }
}

