/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model;

import com.cloudera.nav.sdk.model.MD5IdGenerator;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class HiveIdGenerator {
    public static String generateTableId(String sourceId, String databaseName, String tableName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)sourceId) && !StringUtils.isEmpty((String)databaseName) && !StringUtils.isEmpty((String)tableName) ? 1 : 0) != 0, (Object)"SourceId, database name, and table name must be supplied to generate Hive table identity");
        return MD5IdGenerator.generateIdentity(sourceId, databaseName.toUpperCase(), tableName.toUpperCase());
    }

    public static String generateColumnId(String sourceId, String databaseName, String tableName, String columnName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)sourceId) && !StringUtils.isEmpty((String)databaseName) && !StringUtils.isEmpty((String)tableName) && !StringUtils.isEmpty((String)columnName) ? 1 : 0) != 0, (Object)"SourceId, database name, table name, and column name must be supplied to generate Hive column identity");
        return MD5IdGenerator.generateIdentity(sourceId, databaseName.toUpperCase(), tableName.toUpperCase(), columnName.toUpperCase());
    }
}

