/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MClassUtil {
    public static Map<Field, Method> getAnnotatedProperties(Class<?> mclass, Class<? extends Annotation> annClass) {
        HashMap getters = Maps.newHashMap();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(mclass).getPropertyDescriptors()) {
                getters.put(pd.getName(), pd.getReadMethod());
            }
        }
        catch (IntrospectionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        HashMap properties = Maps.newHashMap();
        for (Field field : MClassUtil.getValidFields(mclass, annClass)) {
            Preconditions.checkArgument((boolean)getters.containsKey(field.getName()), (Object)("No getter method found for " + field.getName()));
            properties.put(field, getters.get(field.getName()));
        }
        return properties;
    }

    private static Collection<Field> getValidFields(Class<?> mclass, Class<? extends Annotation> annClass) {
        LinkedList fields = Lists.newLinkedList();
        for (Field field : mclass.getDeclaredFields()) {
            if (field.isSynthetic() || !field.isAnnotationPresent(annClass)) continue;
            fields.add(field);
        }
        Class<?> superClass = mclass.getSuperclass();
        if (superClass != null) {
            fields.addAll(MClassUtil.getValidFields(superClass, annClass));
        }
        return fields;
    }
}

