/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model;

import com.cloudera.nav.sdk.model.entities.Entity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MD5IdGenerator {
    @VisibleForTesting
    public static Pattern MD5_PATTERN = Pattern.compile("[a-fA-F0-9]{32}");
    private final Hasher hasher = Hashing.md5().newHasher();

    public static String generateIdentity(String ... args) {
        MD5IdGenerator h = new MD5IdGenerator();
        h.update(args);
        return h.getIdentity();
    }

    public static boolean isValidId(String id) {
        return !StringUtils.isEmpty((String)id) && MD5_PATTERN.matcher(id).matches();
    }

    public void update(String arg) {
        this.hasher.putString((CharSequence)arg);
        this.hasher.putString(Entity.ID_SEPARATOR);
    }

    public void update(String ... args) {
        int i = 0;
        for (String arg : args) {
            if (arg != null) {
                this.hasher.putString((CharSequence)arg);
            }
            if (i < args.length - 1) {
                this.hasher.putString(Entity.ID_SEPARATOR);
            }
            ++i;
        }
    }

    public String getIdentity() {
        return this.hasher.hash().toString();
    }
}

