/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model;

import com.cloudera.nav.sdk.model.MClassUtil;
import com.cloudera.nav.sdk.model.MetadataModel;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.custom.CustomProperty;
import com.cloudera.nav.sdk.model.custom.MetaClass;
import com.cloudera.nav.sdk.model.custom.MetaClassPackage;
import com.cloudera.nav.sdk.model.custom.Namespace;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.TagChangeSet;
import com.cloudera.nav.sdk.model.entities.UDPChangeSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MetadataModelFactory {
    public MetadataModel newModel(Collection<? extends Class<? extends Entity>> classes, String namespace) {
        MetadataModel model = new MetadataModel();
        MetaClassPackage pkg = MetaClassPackage.newPackage(namespace);
        model.setPackages(Sets.newHashSet((Object[])new MetaClassPackage[]{pkg}));
        Namespace ns = Namespace.newNamespace(namespace);
        model.setNamespaces(Sets.newHashSet((Object[])new Namespace[]{ns}));
        HashSet metaClasses = Sets.newHashSet();
        HashMap mPropertyMap = Maps.newHashMap();
        HashMap mappings = Maps.newHashMap();
        for (Class<? extends Entity> clazz : classes) {
            MClass ann = clazz.getAnnotation(MClass.class);
            MetaClass mClass = MetaClass.newClass(pkg.getName(), ann.model());
            metaClasses.add(mClass);
            Map<Field, Method> properties = MClassUtil.getAnnotatedProperties(clazz, MProperty.class);
            HashSet classMappings = Sets.newHashSet();
            for (Map.Entry<Field, Method> entry : properties.entrySet()) {
                boolean multiValued;
                String pName;
                Class<?> valueType = entry.getKey().getType();
                MProperty pAnn = entry.getKey().getAnnotation(MProperty.class);
                if (valueType == UDPChangeSet.class || valueType == TagChangeSet.class || !pAnn.register() || !this.checkExitingProperties(pName = StringUtils.isEmpty((String)pAnn.attribute()) ? entry.getKey().getName() : pAnn.attribute(), pAnn, multiValued = Collection.class.isAssignableFrom(valueType), mPropertyMap)) continue;
                mPropertyMap.put(pName, CustomProperty.newProperty(ns.getName(), pName, pAnn.fieldType(), multiValued, pAnn.values()));
                classMappings.add(ns.getName() + "." + pName);
            }
            mappings.put(pkg.getName() + "." + mClass.getName(), classMappings);
        }
        model.setClasses(metaClasses);
        model.setProperties(Sets.newHashSet(mPropertyMap.values()));
        model.setMappings(mappings);
        return model;
    }

    private boolean checkExitingProperties(String pName, MProperty ann, boolean multiValued, Map<String, CustomProperty> mProps) {
        CustomProperty existing = mProps.get(pName);
        if (existing != null) {
            Preconditions.checkArgument((boolean)ann.register());
            Preconditions.checkArgument((ann.fieldType() == existing.getPropertyType() ? 1 : 0) != 0, (Object)String.format("Expecting %s to be of type %s, got %s instead", new Object[]{pName, existing.getPropertyType(), ann.fieldType()}));
            Preconditions.checkArgument((multiValued == existing.isMultiValued() ? 1 : 0) != 0, (Object)String.format("Expecting %s to%sbe multi-valued", pName, multiValued ? " " : " not "));
        }
        return existing == null;
    }
}

