/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model;

import com.cloudera.nav.sdk.model.SourceIdGenerator;
import com.cloudera.nav.sdk.model.SourceType;
import com.google.common.base.Preconditions;

public class Source {
    private final String name;
    private final SourceType sourceType;
    private final String clusterName;
    private final String sourceUrl;
    private final String identity;
    private final Long sourceExtractIteration;

    public Source(String name, SourceType sourceType, String clusterName, String sourceUrl, String identity, Long sourceExtractIteration) {
        Preconditions.checkNotNull((Object)identity);
        this.name = name;
        this.sourceType = sourceType;
        this.clusterName = clusterName;
        this.sourceUrl = sourceUrl;
        this.identity = identity;
        this.sourceExtractIteration = sourceExtractIteration;
    }

    public Source(String name, SourceType sourceType, String clusterName, String sourceUrl, Long sourceExtractIteration) {
        this(name, sourceType, clusterName, sourceUrl, SourceIdGenerator.generateSourceId(clusterName, name), sourceExtractIteration);
    }

    public String getName() {
        return this.name;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getIdentity() {
        return this.identity;
    }

    public Long getSourceExtractIteration() {
        return this.sourceExtractIteration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return this.identity.equals(source.identity);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }
}

