/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.custom;

import com.cloudera.nav.sdk.model.custom.BaseModelObject;
import com.cloudera.nav.sdk.model.custom.CustomPropertyType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomProperty
extends BaseModelObject {
    private String namespace;
    @JsonProperty(value="type")
    private CustomPropertyType propertyType;
    private boolean multiValued;
    private Integer maxLength;
    private String pattern;
    private Set<String> enumValues;

    public static CustomProperty newProperty(String namespace, String name, CustomPropertyType propertyType, boolean multiValued, String[] values) {
        CustomProperty prop = new CustomProperty();
        prop.setNamespace(namespace);
        prop.setName(name);
        prop.setPropertyType(propertyType);
        prop.setMultiValued(multiValued);
        if (propertyType == CustomPropertyType.ENUM) {
            Preconditions.checkNotNull((Object)values);
            Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
            prop.setEnumValues(Sets.newHashSet((Object[])values));
        }
        return prop;
    }

    public CustomPropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(CustomPropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Set<String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(Set<String> enumValues) {
        this.enumValues = enumValues;
    }

    public int hashCode() {
        return 31 * this.getNameHashCode() + this.getNamespaceHashCode();
    }

    private int getNameHashCode() {
        return this.getName() == null ? "".hashCode() : this.getName().hashCode();
    }

    private int getNamespaceHashCode() {
        return this.getNamespace() == null ? "".hashCode() : this.getNamespace().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof CustomProperty) {
            CustomProperty o = (CustomProperty)other;
            return StringUtils.equals((String)this.getName(), (String)o.getName()) && StringUtils.equals((String)this.getNamespace(), (String)o.getNamespace());
        }
        return false;
    }
}

