/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.custom;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

public enum CustomPropertyType {
    BOOLEAN(Boolean.class, Sets.newHashSet((Object[])new Class[]{Boolean.class, Boolean.TYPE})),
    DOUBLE(Double.class, Sets.newHashSet((Object[])new Class[]{Double.class, Double.TYPE, Float.class, Float.TYPE})),
    FLOAT(Float.class, Sets.newHashSet((Object[])new Class[]{Float.class, Float.TYPE, Double.TYPE, Double.class})),
    INTEGER(Integer.class, Sets.newHashSet((Object[])new Class[]{Integer.class, Integer.TYPE})),
    LONG(Long.class, Sets.newHashSet((Object[])new Class[]{Long.class, Long.TYPE, Integer.class, Integer.TYPE})),
    TEXT(String.class, Sets.newHashSet((Object[])new Class[]{String.class})),
    ENUM(Enum.class, Sets.newHashSet((Object[])new Class[]{String.class, Enum.class}));

    private final Class<?> valueType;
    private final Set<Class<?>> validInputTypes;

    private CustomPropertyType(Class<?> valueType, Set<Class<?>> validInputTypes) {
        Preconditions.checkArgument((boolean)validInputTypes.contains(valueType));
        this.valueType = valueType;
        this.validInputTypes = validInputTypes;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public Set<Class<?>> getValidInputTypes() {
        return this.validInputTypes;
    }
}

