/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.custom;

import com.cloudera.nav.sdk.model.custom.BaseModelObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MetaClass
extends BaseModelObject {
    private String packageName;

    public static MetaClass newClass(String packageName, String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)packageName));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name));
        MetaClass metaClass = new MetaClass();
        metaClass.setPackageName(packageName);
        metaClass.setName(name);
        return metaClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public int hashCode() {
        return this.getNameHashCode() * 31 + this.getPackageNameHashCode();
    }

    private int getNameHashCode() {
        return this.getName() == null ? "".hashCode() : this.getName().hashCode();
    }

    private int getPackageNameHashCode() {
        return this.getPackageName() == null ? "".hashCode() : this.getPackageName().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof MetaClass) {
            MetaClass o = (MetaClass)other;
            return StringUtils.equals((String)this.getName(), (String)o.getName()) && StringUtils.equals((String)this.getPackageName(), (String)o.getPackageName());
        }
        return false;
    }
}

