/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.custom;

import com.cloudera.nav.sdk.model.custom.BaseModelObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MetaClassPackage
extends BaseModelObject {
    public static final String DEFAULT_PACKAGE_NAME = "nav";
    private boolean external;

    public static MetaClassPackage newPackage(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name));
        MetaClassPackage pkg = new MetaClassPackage();
        pkg.setName(name);
        return pkg;
    }

    public boolean isDefaultPackage() {
        return StringUtils.equals((String)DEFAULT_PACKAGE_NAME, (String)this.getName());
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public int hashCode() {
        return this.getName() == null ? "".hashCode() : this.getName().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof MetaClassPackage && this.getName() != null && this.getName().equals(((MetaClassPackage)other).getName());
    }
}

