/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.custom;

import com.cloudera.nav.sdk.model.custom.BaseModelObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Namespace
extends BaseModelObject {
    public static final String DEFAULT_NAMESPACE_NAME = "nav";
    private boolean external;

    public static Namespace newNamespace(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name));
        Namespace ns = new Namespace();
        ns.setName(name);
        return ns;
    }

    public boolean isDefaultNamespace() {
        return StringUtils.equals((String)DEFAULT_NAMESPACE_NAME, (String)this.getName());
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public int hashCode() {
        return this.getName() == null ? "".hashCode() : this.getName().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Namespace && this.getName() != null && this.getName().equals(((Namespace)other).getName());
    }
}

