/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.CompressionType;
import com.cloudera.nav.sdk.model.entities.DatasetField;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.entities.FileFormat;
import com.cloudera.nav.sdk.model.entities.SchemaElement;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public abstract class Dataset
extends SchemaElement {
    @MRelation(role=RelationRole.CHILD)
    private Collection<DatasetField> fields;
    @MProperty
    private String datasetType;
    @MProperty
    private List<String> partitionColNames;
    @MProperty
    private List<String> partitionTypes;
    @MProperty
    private CompressionType compressionType;
    @MProperty
    private FileFormat fileFormat;

    public Dataset() {
        this.setEntityType(EntityType.DATASET);
    }

    public String getDatasetType() {
        return this.datasetType;
    }

    public void setDatasetType(String datasetType) {
        this.datasetType = datasetType;
    }

    public Collection<? extends Entity> getFields() {
        return this.fields;
    }

    public void setFields(Collection<? extends DatasetField> fields) {
        if (this.getIdentity() == null) {
            this.setIdentity(this.generateId());
        }
        for (DatasetField datasetField : fields) {
            datasetField.setParentId(this);
        }
        this.fields = Lists.newLinkedList(fields);
    }

    public List<String> getPartitionColNames() {
        return this.partitionColNames;
    }

    public void setPartitionColNames(List<String> partitionColNames) {
        this.partitionColNames = partitionColNames;
    }

    public List<String> getPartitionTypes() {
        return this.partitionTypes;
    }

    public void setPartitionTypes(List<String> partitionTypes) {
        this.partitionTypes = partitionTypes;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }
}

