/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.DatasetIdGenerator;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.entities.SchemaElement;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public abstract class DatasetField
extends SchemaElement {
    @MProperty
    private Integer fieldIndex;
    @MProperty(attribute="firstClassParentId")
    private String parentId;

    public DatasetField() {
        this.setEntityType(EntityType.FIELD);
    }

    @Override
    public String generateId() {
        return DatasetIdGenerator.fieldId(this.getParentId(), this.getName());
    }

    public Integer getFieldIndex() {
        return this.fieldIndex;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setFieldIndex(Integer fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public void setParentId(Entity parent) {
        this.setParentId(parent.getIdentity());
    }

    public void setParentId(String parentId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)parentId), (Object)"DatasetField parent must have valid identity");
        this.parentId = parentId;
    }
}

