/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.entities.TagChangeSet;
import com.cloudera.nav.sdk.model.entities.UDPChangeSet;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.joda.time.Instant;

public abstract class Entity {
    public static final CharSequence ID_SEPARATOR = "##";
    @MProperty
    private String identity;
    @MProperty(required=true)
    private SourceType sourceType;
    @JsonProperty(value="type")
    @MProperty(required=true, attribute="type")
    private EntityType entityType;
    @MProperty
    private String namespace;
    @MProperty
    private String sourceId;
    @MProperty(attribute="originalName")
    private String name;
    @MProperty(attribute="name")
    private String alias;
    @MProperty
    private boolean deleted;
    @MProperty
    private Long deleteTime;
    @MProperty
    private TagChangeSet tags;
    @MProperty
    private UDPChangeSet properties;
    @MProperty
    private Instant created;
    @MProperty
    private String owner;
    @MProperty
    private String description;
    @MProperty
    private String parentPath;

    public String generateId() {
        return this.identity;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Long getDeleteTime() {
        return this.deleteTime;
    }

    public void setDeleteTime(Long deleteTime) {
        this.deleteTime = deleteTime;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant creationTime) {
        this.created = creationTime;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TagChangeSet getTags() {
        if (this.tags == null) {
            this.tags = new TagChangeSet();
        }
        return this.tags;
    }

    public void setTags(String ... tags) {
        this.setTags(Sets.newHashSet((Object[])tags));
    }

    public void setTags(Collection<String> tags) {
        this.getTags().setTags(tags);
    }

    public void addTags(String ... tags) {
        this.addTags(Sets.newHashSet((Object[])tags));
    }

    public void addTags(Collection<String> tags) {
        this.getTags().appendTags(tags);
    }

    public void removeTags(String ... tags) {
        this.removeTags(Sets.newHashSet((Object[])tags));
    }

    public void removeTags(Collection<String> tags) {
        this.getTags().removeTags(tags);
    }

    public UDPChangeSet getProperties() {
        if (this.properties == null) {
            this.properties = new UDPChangeSet();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.getProperties().setProperties(properties);
    }

    public void addProperties(Map<String, String> properties) {
        this.getProperties().addProperties(properties);
    }

    public void removeProperties(Collection<String> keys) {
        this.getProperties().removeProperties(keys);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.identity.equals(entity.identity);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    public Map<String, String> getIdAttrsMap() {
        return Collections.emptyMap();
    }

    public void validateEntity() {
    }
}

