/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@MClass(model="fselement", validTypes={EntityType.DIRECTORY, EntityType.FILE})
public class HdfsEntity
extends Entity {
    @MProperty
    private String fileSystemPath;
    private final String FILE_SYSTEM_PATH = "fileSystemPath";

    public HdfsEntity() {
        this.setSourceType(SourceType.HDFS);
    }

    public HdfsEntity(String fileSystemPath, EntityType type, String sourceId) {
        this();
        this.setSourceId(sourceId);
        this.setFileSystemPath(fileSystemPath);
        this.setEntityType(type);
    }

    public HdfsEntity(String id) {
        this();
        this.setIdentity(id);
    }

    @Override
    public void validateEntity() {
        if (Strings.isNullOrEmpty((String)this.getIdentity()) && Strings.isNullOrEmpty((String)this.getFileSystemPath()) || Strings.isNullOrEmpty((String)this.getSourceId())) {
            throw new IllegalArgumentException("Either the Entity Id or file system path used to generate the id must be present along with the source id");
        }
    }

    public void setFileSystemPath(String fileSystemPath) {
        this.fileSystemPath = fileSystemPath;
    }

    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    @Override
    public Map<String, String> getIdAttrsMap() {
        return ImmutableMap.of((Object)"fileSystemPath", (Object)this.getFileSystemPath());
    }
}

