/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.HiveIdGenerator;
import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;

@MClass(model="hv_column")
public class HiveColumn
extends Entity {
    @MProperty
    private String databaseName;
    @MProperty
    private String tableName;

    public HiveColumn() {
        this.setSourceType(SourceType.HIVE);
        this.setEntityType(EntityType.FIELD);
    }

    public HiveColumn(String sourceId, String db, String table, String column) {
        this();
        this.setSourceId(sourceId);
        this.setDatabaseName(db);
        this.setTableName(table);
        this.setColumnName(column);
        this.setIdentity(this.generateId());
    }

    @Override
    public String generateId() {
        return HiveIdGenerator.generateColumnId(this.getSourceId(), this.getDatabaseName(), this.getTableName(), this.getColumnName());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.getName();
    }

    public void setColumnName(String columnName) {
        this.setName(columnName);
    }
}

