/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.HiveIdGenerator;
import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;

@MClass(model="hv_table")
public class HiveTable
extends Entity {
    @MProperty
    private String databaseName;

    public HiveTable() {
        this.setSourceType(SourceType.HIVE);
        this.setEntityType(EntityType.TABLE);
    }

    public HiveTable(String sourceId, String db, String table) {
        this();
        this.setSourceId(sourceId);
        this.setDatabaseName(db);
        this.setTableName(table);
        this.setIdentity(this.generateId());
    }

    @Override
    public String generateId() {
        return HiveIdGenerator.generateTableId(this.getSourceId(), this.getDatabaseName(), this.getTableName());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.getName();
    }

    public void setTableName(String tableName) {
        this.setName(tableName);
    }
}

