/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@MClass(model="pig_operation", validTypes={EntityType.OPERATION})
public class PigOperation
extends Entity {
    private final String JOB_NAME = "jobName";
    private final String LOGICAL_PLAN_HASH = "logicalPlanHash";
    @MProperty
    private String jobName;
    @MProperty
    private String logicalPlanHash;

    public PigOperation() {
        this.setSourceType(SourceType.PIG);
        this.setEntityType(EntityType.OPERATION);
    }

    public PigOperation(String logicalPlanHash, String jobName) {
        this();
        this.setLogicalPlanHash(logicalPlanHash);
        this.setJobName(jobName);
    }

    public PigOperation(String id) {
        this();
        this.setIdentity(id);
    }

    @Override
    public void validateEntity() {
        if (Strings.isNullOrEmpty((String)this.getIdentity()) && (Strings.isNullOrEmpty((String)this.getJobName()) || Strings.isNullOrEmpty((String)this.getLogicalPlanHash()))) {
            throw new IllegalArgumentException("Either the Entity Id or the jobname and the logical plan must be provided");
        }
    }

    public void setLogicalPlanHash(String logicalPlanHash) {
        this.logicalPlanHash = logicalPlanHash;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getLogicalPlanHash() {
        return this.logicalPlanHash;
    }

    @Override
    public Map<String, String> getIdAttrsMap() {
        return ImmutableMap.of((Object)"jobName", (Object)this.getJobName(), (Object)"logicalPlanHash", (Object)this.getLogicalPlanHash());
    }
}

