/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@MClass(model="pig_op_exec", validTypes={EntityType.OPERATION_EXECUTION})
public class PigOperationExecution
extends Entity {
    private final String JOB_NAME = "jobName";
    private final String SCRIPT_ID = "scriptId";
    @MProperty
    private String jobName;
    @MProperty
    private String scriptId;

    public PigOperationExecution() {
        this.setSourceType(SourceType.PIG);
        this.setEntityType(EntityType.OPERATION_EXECUTION);
    }

    public PigOperationExecution(String id) {
        this();
        this.setIdentity(id);
    }

    public PigOperationExecution(String scriptId, String jobName) {
        this();
        this.setScriptId(scriptId);
        this.setJobName(jobName);
    }

    @Override
    public void validateEntity() {
        if (Strings.isNullOrEmpty((String)this.getIdentity()) && (Strings.isNullOrEmpty((String)this.getJobName()) || Strings.isNullOrEmpty((String)this.getScriptId()))) {
            throw new IllegalArgumentException("Either the Entity Id or the jobname and the script id must be provided");
        }
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    @Override
    public Map<String, String> getIdAttrsMap() {
        return ImmutableMap.of((Object)"jobName", (Object)this.getJobName(), (Object)"scriptId", (Object)this.getScriptId());
    }
}

