/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class TagChangeSet {
    @JsonProperty(value="add")
    private Set<String> newTags = Sets.newHashSet();
    @JsonProperty(value="del")
    private Set<String> delTags = Sets.newHashSet();
    @JsonProperty(value="set")
    private Set<String> overrideTags = null;

    public void appendTags(Collection<String> tags) {
        if (CollectionUtils.isNotEmpty(tags)) {
            this.newTags.addAll(tags);
            this.delTags.removeAll(tags);
            if (this.overrideTags != null) {
                this.overrideTags.removeAll(tags);
            }
        }
    }

    public void removeTags(Collection<String> tags) {
        if (CollectionUtils.isNotEmpty(tags)) {
            this.delTags.addAll(tags);
            this.newTags.removeAll(tags);
            if (this.overrideTags != null) {
                this.overrideTags.removeAll(tags);
            }
        }
    }

    public void setTags(Collection<String> tags) {
        if (tags == null) {
            this.overrideTags = null;
        } else {
            this.overrideTags = Sets.newHashSet(tags);
            this.delTags.removeAll(tags);
            this.newTags.removeAll(tags);
        }
    }

    public void reset() {
        this.newTags.clear();
        this.delTags.clear();
        this.overrideTags = null;
    }

    public Set<String> getNewTags() {
        return this.newTags;
    }

    public void setNewTags(Set<String> newTags) {
        if (newTags == null) {
            newTags = Sets.newHashSet();
        }
        this.newTags = newTags;
    }

    public Set<String> getOverrideTags() {
        return this.overrideTags;
    }

    public boolean hasOverrides() {
        return this.overrideTags != null;
    }

    public void setOverrideTags(Set<String> overrideTags) {
        this.overrideTags = overrideTags;
    }

    public Set<String> getDelTags() {
        return this.delTags;
    }

    public void setDelTags(Set<String> delTags) {
        if (delTags == null) {
            delTags = Sets.newHashSet();
        }
        this.delTags = delTags;
    }
}

