/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class UDPChangeSet {
    @JsonProperty(value="add")
    private Map<String, String> newProperties = Maps.newHashMap();
    @JsonProperty(value="del")
    private Set<String> removeProperties = Sets.newHashSet();
    @JsonProperty(value="set")
    private Map<String, String> overrideProperties = null;

    public void reset() {
        this.newProperties.clear();
        this.removeProperties.clear();
        this.overrideProperties = null;
    }

    public void addProperties(Map<String, String> properties) {
        if (MapUtils.isNotEmpty(properties)) {
            this.newProperties.putAll(properties);
            this.removeProperties.removeAll(properties.keySet());
            if (this.overrideProperties != null) {
                this.overrideProperties = Maps.newHashMap((Map)Maps.difference(this.overrideProperties, properties).entriesOnlyOnLeft());
            }
        }
    }

    public void removeProperties(Collection<String> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            this.removeProperties.addAll(keys);
            for (String k : keys) {
                this.newProperties.remove(k);
            }
            if (this.overrideProperties != null) {
                for (String k : keys) {
                    this.overrideProperties.remove(k);
                }
            }
        }
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            this.overrideProperties = null;
        } else {
            this.removeProperties.removeAll(properties.keySet());
            this.newProperties = Maps.newHashMap((Map)Maps.difference(this.newProperties, properties).entriesOnlyOnLeft());
            this.overrideProperties = Maps.newHashMap(properties);
        }
    }

    public Map<String, String> getNewProperties() {
        return this.newProperties;
    }

    public void setNewProperties(Map<String, String> newProperties) {
        if (newProperties == null) {
            newProperties = Maps.newHashMap();
        }
        this.newProperties = newProperties;
    }

    public Map<String, String> getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Map<String, String> overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public boolean hasOverrides() {
        return this.overrideProperties != null;
    }

    public Set<String> getRemoveProperties() {
        return this.removeProperties;
    }

    public void setRemoveProperties(Set<String> removeProperties) {
        if (removeProperties == null) {
            removeProperties = Sets.newHashSet();
        }
        this.removeProperties = removeProperties;
    }

    public static UDPChangeSet copyOf(UDPChangeSet properties) {
        UDPChangeSet rs = new UDPChangeSet();
        rs.overrideProperties = Maps.newHashMap(properties.getOverrideProperties());
        rs.newProperties = Maps.newHashMap(properties.getNewProperties());
        rs.removeProperties = Sets.newHashSet(properties.getRemoveProperties());
        return rs;
    }
}

