/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.relations.Relation;
import com.cloudera.nav.sdk.model.relations.RelationType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;

public final class DataFlowRelation
extends Relation {
    public static Builder<?> builder() {
        return new Builder();
    }

    private DataFlowRelation(Builder<?> builder) {
        super(builder);
    }

    public Collection<String> getSourceIds() {
        return this.getEp1Ids();
    }

    public Collection<String> getTargetIds() {
        return this.getEp2Ids();
    }

    public SourceType getSourceTypeOfSource() {
        return this.getEp1SourceType();
    }

    public SourceType getSourceTypeOfTarget() {
        return this.getEp2SourceType();
    }

    public static class Builder<T extends Builder<T>>
    extends Relation.Builder<T> {
        protected Builder() {
            super(RelationType.DATA_FLOW);
        }

        @Override
        protected T self() {
            return (T)this;
        }

        @Override
        public DataFlowRelation build() {
            return new DataFlowRelation(this);
        }

        public T sourceIds(Collection<String> sourceIds) {
            return (T)((Builder)this.ep1Ids(sourceIds));
        }

        public T sourceId(String sourceId) {
            return this.sourceIds(Collections.singleton(sourceId));
        }

        public T targetIds(Collection<String> targetIds) {
            return (T)((Builder)this.ep2Ids(targetIds));
        }

        public T targetId(String targetId) {
            return this.targetIds(Collections.singleton(targetId));
        }

        public T sourceTypeOfSource(SourceType sourceType) {
            return (T)((Builder)this.ep1SourceType(sourceType));
        }

        public T sourceTypeOfTarget(SourceType sourceType) {
            return (T)((Builder)this.ep2SourceType(sourceType));
        }

        public T source(Entity src) {
            return this.sources((Collection<Entity>)ImmutableList.of((Object)src));
        }

        public T sources(Collection<Entity> src) {
            return (T)((Builder)this.ep1(src));
        }

        public T target(Entity tgt) {
            return this.targets((Collection<Entity>)ImmutableList.of((Object)tgt));
        }

        public T targets(Collection<Entity> tgt) {
            return (T)((Builder)this.ep2(tgt));
        }
    }
}

