/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.relations.Relation;
import com.cloudera.nav.sdk.model.relations.RelationType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;

public final class InstanceOfRelation
extends Relation {
    public static Builder<?> builder() {
        return new Builder();
    }

    private InstanceOfRelation(Builder<?> builder) {
        super(builder);
    }

    public String getTemplateId() {
        return (String)Iterables.getOnlyElement(this.getEp1Ids());
    }

    public Collection<String> getInstanceIds() {
        return this.getEp2Ids();
    }

    public SourceType getSourceTypeOfTemplate() {
        return this.getEp1SourceType();
    }

    public SourceType getSourceTypeOfInstance() {
        return this.getEp2SourceType();
    }

    public static class Builder<T extends Builder<T>>
    extends Relation.Builder<T> {
        protected Builder() {
            super(RelationType.INSTANCE_OF);
        }

        @Override
        protected T self() {
            return (T)this;
        }

        @Override
        public InstanceOfRelation build() {
            return new InstanceOfRelation(this);
        }

        public T templateId(String templateId) {
            return (T)((Builder)this.ep1Ids(Collections.singleton(templateId)));
        }

        public T instanceId(String instanceId) {
            return (T)((Builder)this.ep2Ids(Collections.singleton(instanceId)));
        }

        public T sourceTypeOfTemplate(SourceType sourceType) {
            return (T)((Builder)this.ep1SourceType(sourceType));
        }

        public T sourceTypeOfInstance(SourceType sourceType) {
            return (T)((Builder)this.ep2SourceType(sourceType));
        }

        public T template(Entity src) {
            return (T)((Builder)this.ep1((Collection<Entity>)ImmutableList.of((Object)src)));
        }

        public T instance(Entity instance) {
            return this.instances(Collections.singleton(instance));
        }

        public T instances(Collection<Entity> instance) {
            return (T)((Builder)this.ep2(instance));
        }
    }
}

