/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.relations.Relation;
import com.cloudera.nav.sdk.model.relations.RelationType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;

public final class LogicalPhysicalRelation
extends Relation {
    public static Builder<?> builder() {
        return new Builder();
    }

    private LogicalPhysicalRelation(Builder<?> builder) {
        super(builder);
    }

    public String getLogicalId() {
        return (String)Iterables.getOnlyElement(this.getEp1Ids());
    }

    public Collection<String> getPhysicalIds() {
        return this.getEp2Ids();
    }

    public SourceType getSourceTypeOfLogical() {
        return this.getEp1SourceType();
    }

    public SourceType getSourceTypeOfPhysical() {
        return this.getEp2SourceType();
    }

    public static class Builder<T extends Builder<T>>
    extends Relation.Builder<T> {
        protected Builder() {
            super(RelationType.LOGICAL_PHYSICAL);
        }

        @Override
        protected T self() {
            return (T)this;
        }

        @Override
        public LogicalPhysicalRelation build() {
            return new LogicalPhysicalRelation(this);
        }

        public T logicalId(String logicalId) {
            return (T)((Builder)this.ep1Ids(Collections.singleton(logicalId)));
        }

        public T physicalIds(Collection<String> physicalIds) {
            return (T)((Builder)this.ep2Ids(physicalIds));
        }

        public T physicalId(String physicalId) {
            return this.physicalIds(Collections.singleton(physicalId));
        }

        public T sourceTypeOfLogical(SourceType sourceType) {
            return (T)((Builder)this.ep1SourceType(sourceType));
        }

        public T sourceTypeOfPhysical(SourceType sourceType) {
            return (T)((Builder)this.ep2SourceType(sourceType));
        }

        public T logical(Entity src) {
            return (T)((Builder)this.ep1((Collection<Entity>)ImmutableList.of((Object)src)));
        }

        public T physical(Entity physical) {
            return this.physical((Collection<Entity>)ImmutableList.of((Object)physical));
        }

        public T physical(Collection<Entity> physical) {
            return (T)((Builder)this.ep2(physical));
        }
    }
}

