/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.relations.Relation;
import com.cloudera.nav.sdk.model.relations.RelationType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;

public final class ParentChildRelation
extends Relation {
    public static Builder<?> builder() {
        return new Builder();
    }

    private ParentChildRelation(Builder<?> builder) {
        super(builder);
    }

    public String getParentId() {
        return (String)Iterables.getOnlyElement(this.getEp1Ids());
    }

    public Collection<String> getChildrenIds() {
        return this.getEp2Ids();
    }

    public SourceType getSourceTypeOfParent() {
        return this.getEp1SourceType();
    }

    public SourceType getSourceTypeOfChildren() {
        return this.getEp2SourceType();
    }

    public static class Builder<T extends Builder<T>>
    extends Relation.Builder<T> {
        protected Builder() {
            super(RelationType.PARENT_CHILD);
        }

        @Override
        protected T self() {
            return (T)this;
        }

        @Override
        public ParentChildRelation build() {
            return new ParentChildRelation(this);
        }

        public T parentId(String parentId) {
            return (T)((Builder)this.ep1Ids(Collections.singleton(parentId)));
        }

        public T childrenIds(Collection<String> childrenIds) {
            return (T)((Builder)this.ep2Ids(childrenIds));
        }

        public T childId(String childId) {
            return this.childrenIds(Collections.singleton(childId));
        }

        public T sourceTypeOfParent(SourceType sourceType) {
            return (T)((Builder)this.ep1SourceType(sourceType));
        }

        public T sourceTypeOfChildren(SourceType sourceType) {
            return (T)((Builder)this.ep2SourceType(sourceType));
        }

        public T parent(Entity src) {
            return (T)((Builder)this.ep1((Collection<Entity>)ImmutableList.of((Object)src)));
        }

        public T child(Entity child) {
            return this.children((Collection<Entity>)ImmutableList.of((Object)child));
        }

        public T children(Collection<Entity> children) {
            return (T)((Builder)this.ep2(children));
        }
    }
}

