/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationIdGenerator;
import com.cloudera.nav.sdk.model.relations.RelationType;
import com.cloudera.nav.sdk.model.relations.RelationValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class Relation {
    private static RelationValidator validator = new RelationValidator();
    @MProperty(required=true)
    private String namespace;
    @MProperty(required=true)
    private String identity = UUID.randomUUID().toString();
    @MProperty(required=true)
    private RelationType type;
    @MProperty(attribute="endpoint1Ids")
    private Collection<String> ep1Ids;
    @MProperty(required=true, attribute="endpoint1SourceType")
    private SourceType ep1SourceType;
    @MProperty(attribute="endpoint2Ids")
    private Collection<String> ep2Ids;
    @MProperty(required=true, attribute="endpoint2SourceType")
    private SourceType ep2SourceType;
    @MProperty(required=true, attribute="endpoint1Type")
    private EntityType ep1Type;
    @MProperty(required=true, attribute="endpoint2Type")
    private EntityType ep2Type;
    @MProperty(attribute="endpoint1SourceId")
    private String ep1SourceId;
    @MProperty(attribute="endpoint2SourceId")
    private String ep2SourceId;
    @MProperty
    private boolean userSpecified;
    @MProperty
    private Collection<Map<String, String>> ep1Attributes;
    @MProperty
    private Collection<Map<String, String>> ep2Attributes;

    protected Relation(Builder<?> builder) {
        this.type = ((Builder)builder).type;
        this.namespace = ((Builder)builder).namespace;
        this.ep1Ids = ((Builder)builder).ep1Ids;
        this.ep1Type = ((Builder)builder).ep1Type;
        this.ep1SourceType = ((Builder)builder).ep1SourceType;
        this.ep1SourceId = ((Builder)builder).ep1SourceId;
        this.ep2Ids = ((Builder)builder).ep2Ids;
        this.ep2Type = ((Builder)builder).ep2Type;
        this.ep2SourceType = ((Builder)builder).ep2SourceType;
        this.ep2SourceId = ((Builder)builder).ep2SourceId;
        this.userSpecified = ((Builder)builder).userSpecified;
        this.ep1Attributes = ((Builder)builder).ep1Attributes;
        this.ep2Attributes = ((Builder)builder).ep2Attributes;
        validator.validateRequiredMProperties(this);
        validator.validatateRelation(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentity() {
        return this.identity;
    }

    public RelationType getType() {
        return this.type;
    }

    public Collection<String> getEp1Ids() {
        return this.ep1Ids;
    }

    public EntityType getEp1Type() {
        return this.ep1Type;
    }

    public Collection<String> getEp2Ids() {
        return this.ep2Ids;
    }

    public EntityType getEp2Type() {
        return this.ep2Type;
    }

    public SourceType getEp1SourceType() {
        return this.ep1SourceType;
    }

    public String getEp1SourceId() {
        return this.ep1SourceId;
    }

    public SourceType getEp2SourceType() {
        return this.ep2SourceType;
    }

    public String getEp2SourceId() {
        return this.ep2SourceId;
    }

    public boolean isUserSpecified() {
        return this.userSpecified;
    }

    public Collection<Map<String, String>> getEp1Attributes() {
        return this.ep1Attributes;
    }

    public Collection<Map<String, String>> getEp2Attributes() {
        return this.ep2Attributes;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final RelationType type;
        private String namespace;
        private String identity;
        private Collection<String> ep1Ids;
        private Collection<Map<String, String>> ep1Attributes;
        private EntityType ep1Type;
        private SourceType ep1SourceType;
        private String ep1SourceId;
        private Collection<String> ep2Ids;
        private EntityType ep2Type;
        private SourceType ep2SourceType;
        private String ep2SourceId;
        private Collection<Map<String, String>> ep2Attributes;
        private boolean userSpecified;
        private RelationIdGenerator idGenerator;

        protected Builder(RelationType type) {
            this.type = type;
        }

        protected abstract T self();

        public T ep1Attributes(Collection<Map<String, String>> ep1Attributes) {
            this.ep1Attributes = ep1Attributes;
            return this.self();
        }

        public T ep2Attributes(Collection<Map<String, String>> ep2Attributes) {
            this.ep2Attributes = ep2Attributes;
            return this.self();
        }

        public T namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        public T identity(String identity) {
            this.identity = identity;
            return this.self();
        }

        public T idGenerator(RelationIdGenerator idGenerator) {
            this.idGenerator = idGenerator;
            return this.self();
        }

        public T ep1Ids(Collection<String> ep1Ids) {
            this.ep1Ids = ep1Ids;
            return this.self();
        }

        public T ep1Type(EntityType ep1Type) {
            this.ep1Type = ep1Type;
            return this.self();
        }

        public T ep2Ids(Collection<String> ep2Ids) {
            this.ep2Ids = ep2Ids;
            return this.self();
        }

        public T ep2Type(EntityType ep2Type) {
            this.ep2Type = ep2Type;
            return this.self();
        }

        public T ep1SourceType(SourceType ep1SourceType) {
            this.ep1SourceType = ep1SourceType;
            return this.self();
        }

        public T ep1SourceId(String ep1SourceId) {
            this.ep1SourceId = ep1SourceId;
            return this.self();
        }

        public T ep2SourceType(SourceType ep2SourceType) {
            this.ep2SourceType = ep2SourceType;
            return this.self();
        }

        public T ep2SourceId(String ep2SourceId) {
            this.ep2SourceId = ep2SourceId;
            return this.self();
        }

        public T userSpecified(boolean userSpecified) {
            this.userSpecified = userSpecified;
            return this.self();
        }

        public T ep1(Collection<Entity> ep1Entities) {
            Collection<String> ids = this.prepEndpoint(ep1Entities);
            Entity proto = (Entity)Iterables.getFirst(ep1Entities, null);
            Preconditions.checkNotNull((Object)proto);
            return ((Builder)((Builder)((Builder)this.ep1Ids(ids)).ep1SourceType(proto.getSourceType())).ep1Type(proto.getEntityType())).ep1SourceId(proto.getSourceId());
        }

        public T ep2(Collection<Entity> ep2Entities) {
            Collection<String> ids = this.prepEndpoint(ep2Entities);
            Entity proto = (Entity)Iterables.getFirst(ep2Entities, null);
            Preconditions.checkNotNull((Object)proto);
            return ((Builder)((Builder)((Builder)this.ep2Ids(ids)).ep2SourceType(proto.getSourceType())).ep2Type(proto.getEntityType())).ep2SourceId(proto.getSourceId());
        }

        private Collection<String> prepEndpoint(Collection<Entity> entities) {
            Preconditions.checkArgument((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0);
            ArrayList ids = Lists.newArrayList();
            Entity proto = null;
            for (Entity en : entities) {
                if (en.getIdentity() != null) {
                    ids.add(en.getIdentity());
                }
                if (proto == null) {
                    proto = en;
                    continue;
                }
                Preconditions.checkArgument((StringUtils.equals((String)proto.getSourceId(), (String)en.getSourceId()) && proto.getSourceType() == en.getSourceType() && proto.getEntityType() == en.getEntityType() ? 1 : 0) != 0);
            }
            return ids;
        }

        public abstract Relation build();
    }
}

