/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

public enum RelationRole {
    SOURCE(EndPoint.ENDPOINT1),
    TARGET(EndPoint.ENDPOINT2),
    PARENT(EndPoint.ENDPOINT1),
    CHILD(EndPoint.ENDPOINT2),
    LOGICAL(EndPoint.ENDPOINT1),
    PHYSICAL(EndPoint.ENDPOINT2),
    TEMPLATE(EndPoint.ENDPOINT1),
    INSTANCE(EndPoint.ENDPOINT2),
    ENDPOINT1(EndPoint.ENDPOINT1),
    ENDPOINT2(EndPoint.ENDPOINT2);

    private final EndPoint endPoint;

    private RelationRole(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public RelationRole getInverseRole() {
        switch (this) {
            case SOURCE: {
                return TARGET;
            }
            case TARGET: {
                return SOURCE;
            }
            case PARENT: {
                return CHILD;
            }
            case CHILD: {
                return PARENT;
            }
            case PHYSICAL: {
                return LOGICAL;
            }
            case LOGICAL: {
                return PHYSICAL;
            }
            case TEMPLATE: {
                return INSTANCE;
            }
            case INSTANCE: {
                return TEMPLATE;
            }
            case ENDPOINT1: {
                return ENDPOINT2;
            }
            case ENDPOINT2: {
                return ENDPOINT1;
            }
        }
        throw new IllegalArgumentException("Unknown role " + String.valueOf((Object)this));
    }

    public static enum EndPoint {
        ENDPOINT1,
        ENDPOINT2;

    }
}

