/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.nav.sdk.model.relations;

import com.cloudera.nav.sdk.model.MClassUtil;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.relations.Relation;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class RelationValidator {
    Map<Field, Method> mclassInfo = MClassUtil.getAnnotatedProperties(Relation.class, MProperty.class);

    public void validateRequiredMProperties(Relation relation) {
        for (Map.Entry<Field, Method> entry : this.mclassInfo.entrySet()) {
            if (!entry.getKey().getAnnotation(MProperty.class).required()) continue;
            try {
                Object value = entry.getValue().invoke((Object)relation, new Object[0]);
                Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)String.format("Required property %s was null", entry.getKey().getName()));
                if (!(value instanceof Collection)) continue;
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)((Collection)value)), (Object)String.format("Required property %s was null", entry.getKey().getName()));
            }
            catch (IllegalAccessException e) {
                Throwables.propagate((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public void validatateRelation(Relation relation) {
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(relation.getEp1Ids()) || CollectionUtils.isNotEmpty(relation.getEp1Attributes()) ? 1 : 0) != 0, (Object)"Either ep1Ids or ep1Attributes must be present");
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(relation.getEp2Ids()) || CollectionUtils.isNotEmpty(relation.getEp2Attributes()) ? 1 : 0) != 0, (Object)"Either ep2Ids or ep2Attributes must be present");
    }
}

