/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.asm.ClassVisitor;
import org.neo4j.codegen.asm.ClassWriter;
import org.neo4j.codegen.asm.FieldVisitor;
import org.neo4j.codegen.asm.MethodVisitor;
import org.neo4j.codegen.bytecode.ByteCodeExpressionVisitor;
import org.neo4j.codegen.bytecode.MethodByteCodeEmitter;

class ClassByteCodeWriter
implements ClassEmitter {
    private final ClassWriter classWriter;
    private final ClassVisitor classVisitor;
    private final TypeReference type;
    private final Map<FieldReference, Expression> staticFields = new HashMap<FieldReference, Expression>();
    private final TypeReference base;

    ClassByteCodeWriter(TypeReference type, TypeReference base, TypeReference[] interfaces) {
        this.classWriter = new ClassWriter(2);
        this.classVisitor = this.classWriter;
        String[] iNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            iNames[i] = ByteCodeUtils.byteCodeName(interfaces[i]);
        }
        this.classVisitor.visit(52, 33, ByteCodeUtils.byteCodeName(type), ByteCodeUtils.signature(type), ByteCodeUtils.byteCodeName(base), (String[])(iNames.length != 0 ? iNames : null));
        if (base.isInnerClass()) {
            this.classVisitor.visitInnerClass(ByteCodeUtils.byteCodeName(base), ByteCodeUtils.outerName(base), base.simpleName(), 9);
        }
        this.type = type;
        this.base = base;
    }

    @Override
    public MethodEmitter method(MethodDeclaration signature) {
        return new MethodByteCodeEmitter(this.classVisitor, signature, this.base);
    }

    @Override
    public void field(FieldReference field, Expression value) {
        if (Modifier.isStatic(field.modifiers()) && value != null) {
            this.staticFields.put(field, value);
        }
        FieldVisitor fieldVisitor = this.classVisitor.visitField(field.modifiers(), field.name(), ByteCodeUtils.typeName(field.type()), ByteCodeUtils.signature(field.type()), null);
        fieldVisitor.visitEnd();
    }

    @Override
    public void done() {
        if (!this.staticFields.isEmpty()) {
            MethodVisitor methodVisitor = this.classVisitor.visitMethod(8, "<clinit>", "()V", null, null);
            ByteCodeExpressionVisitor expressionVisitor = new ByteCodeExpressionVisitor(methodVisitor);
            methodVisitor.visitCode();
            for (Map.Entry<FieldReference, Expression> entry : this.staticFields.entrySet()) {
                FieldReference field = entry.getKey();
                Expression value = entry.getValue();
                value.accept(expressionVisitor);
                methodVisitor.visitFieldInsn(179, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
            }
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        this.classVisitor.visitEnd();
    }

    ByteCodes toByteCodes() {
        final byte[] bytecode = this.classWriter.toByteArray();
        return new ByteCodes(){

            @Override
            public String name() {
                return ClassByteCodeWriter.this.type.fullName();
            }

            @Override
            public ByteBuffer bytes() {
                return ByteBuffer.wrap(bytecode);
            }
        };
    }
}

