/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.Table;
import org.neo4j.collection.primitive.hopscotch.UnsafeTable;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class LongKeyLongValueUnsafeTable
extends UnsafeTable<long[]> {
    public LongKeyLongValueUnsafeTable(int capacity) {
        super(capacity, 16, new long[1]);
    }

    @Override
    protected long internalKey(long keyAddress) {
        return UnsafeUtil.getLong((long)keyAddress);
    }

    @Override
    protected void internalPut(long keyAddress, long key, long[] value) {
        UnsafeUtil.putLong((long)keyAddress, (long)key);
        UnsafeUtil.putLong((long)(keyAddress + 8L), (long)value[0]);
    }

    @Override
    protected long[] internalRemove(long keyAddress) {
        ((long[])this.valueMarker)[0] = UnsafeUtil.getLong((long)(keyAddress + 8L));
        UnsafeUtil.putLong((long)keyAddress, (long)-1L);
        return (long[])this.valueMarker;
    }

    @Override
    public long[] putValue(int index, long[] value) {
        long valueAddress = this.valueAddress(index);
        long oldValue = UnsafeUtil.getLong((long)valueAddress);
        UnsafeUtil.putLong((long)valueAddress, (long)value[0]);
        return this.pack(oldValue);
    }

    private long[] pack(long value) {
        ((long[])this.valueMarker)[0] = value;
        return (long[])this.valueMarker;
    }

    private long valueAddress(int index) {
        return this.keyAddress(index) + 8L;
    }

    @Override
    public long[] value(int index) {
        long value = UnsafeUtil.getLong((long)this.valueAddress(index));
        return this.pack(value);
    }

    @Override
    protected Table<long[]> newInstance(int newCapacity) {
        return new LongKeyLongValueUnsafeTable(newCapacity);
    }
}

