/*
 * Decompiled with CFR 0.152.
 */
package org.ojai;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.annotation.API;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Public
public interface DocumentReader {
    public EventType next();

    public boolean inMap();

    public String getFieldName();

    public int getArrayIndex();

    public byte getByte();

    public short getShort();

    public int getInt();

    public long getLong();

    public float getFloat();

    public double getDouble();

    public BigDecimal getDecimal();

    public int getDecimalPrecision();

    public int getDecimalScale();

    public int getDecimalValueAsInt();

    public long getDecimalValueAsLong();

    public ByteBuffer getDecimalValueAsBytes();

    public boolean getBoolean();

    public String getString();

    public long getTimestampLong();

    public OTimestamp getTimestamp();

    public int getDateInt();

    public ODate getDate();

    public int getTimeInt();

    public OTime getTime();

    public OInterval getInterval();

    public int getIntervalDays();

    public long getIntervalMillis();

    public ByteBuffer getBinary();

    public static enum EventType {
        NULL,
        BOOLEAN,
        STRING,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        DECIMAL,
        DATE,
        TIME,
        TIMESTAMP,
        INTERVAL,
        BINARY,
        START_MAP,
        END_MAP,
        START_ARRAY,
        END_ARRAY;

    }
}

