/*
 * Decompiled with CFR 0.152.
 */
package org.ojai;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.ojai.FieldSegment;
import org.ojai.annotation.API;
import org.ojai.antlr4.FieldPathLexer;
import org.ojai.antlr4.FieldPathParser;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Public
public final class FieldPath
implements Comparable<FieldPath>,
Iterable<FieldSegment> {
    private static Logger logger = LoggerFactory.getLogger(FieldPath.class);
    public static final FieldPath EMPTY = new FieldPath(new FieldSegment.NameSegment("", null, false));
    private static Cache<String, FieldPath> fieldPathCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final FieldSegment.NameSegment rootSegment;

    public static FieldPath parseFrom(String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("Can not parse null string as FieldPath.");
        }
        if (fieldPath.isEmpty()) {
            return EMPTY;
        }
        FieldPath fp = null;
        fp = (FieldPath)fieldPathCache.getIfPresent((Object)fieldPath);
        if (fp == null) {
            try {
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)new FieldPathLexer((CharStream)new ANTLRInputStream(fieldPath)));
                FieldPathErrorListener listener = new FieldPathErrorListener();
                FieldPathParser parser = new FieldPathParser((TokenStream)tokens);
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)listener);
                fp = parser.parse().fp;
                if (listener.isError()) {
                    throw new IllegalArgumentException("'" + fieldPath + "' is not a valid FieldPath: " + listener.getErrorMsg(), listener.getException());
                }
                fieldPathCache.put((Object)fieldPath, (Object)fp);
            }
            catch (RecognitionException e) {
                logger.error("Error parsing {} as a FieldPath: {}.", (Object)fieldPath, (Object)e.getMessage());
                throw new IllegalArgumentException("Unable to parse '" + fieldPath + "' as a FieldPath.", e);
            }
        }
        return EMPTY.equals(fp) ? EMPTY : fp;
    }

    @Override
    public Iterator<FieldSegment> iterator() {
        return new FieldSegmentIterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldPath)) {
            return false;
        }
        FieldPath other = (FieldPath)obj;
        if (this.rootSegment == null) {
            return other.rootSegment == null;
        }
        return this.rootSegment.equals(other.rootSegment);
    }

    public int hashCode() {
        return this.rootSegment == null ? 0 : this.rootSegment.hashCode();
    }

    public String toString() {
        return this.asPathString();
    }

    @Override
    public int compareTo(FieldPath other) {
        return this.rootSegment.compareTo(other.getRootSegment());
    }

    public String asPathString() {
        return this.rootSegment.asPathString(false);
    }

    public String asPathString(boolean quote) {
        return this.rootSegment.asPathString(quote);
    }

    public FieldSegment getRootSegment() {
        return this.rootSegment;
    }

    public FieldPath cloneWithNewParent(String parentSegment) {
        String rootSegmentName = Fields.unquoteFieldName(parentSegment);
        FieldSegment.NameSegment newRoot = new FieldSegment.NameSegment(parentSegment, this.rootSegment.clone(), rootSegmentName != parentSegment);
        return new FieldPath(newRoot);
    }

    public FieldPath cloneWithNewChild(String childSegment) {
        FieldSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new FieldSegment.NameSegment(childSegment));
        return new FieldPath(newRoot);
    }

    public FieldPath cloneWithNewChild(int index) {
        FieldSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new FieldSegment.IndexSegment(index));
        return new FieldPath(newRoot);
    }

    public FieldPath cloneWithNewChild(FieldSegment childSegment) {
        return new FieldPath(this.rootSegment.cloneWithNewChild(childSegment));
    }

    public FieldPath cloneAfterAncestor(FieldPath ancestor) {
        FieldSegment c2;
        if (this == ancestor) {
            return EMPTY;
        }
        FieldSegment c1 = this.rootSegment;
        for (c2 = ancestor.rootSegment; c1 != null && c2 != null; c1 = c1.getChild(), c2 = c2.getChild()) {
            if (c1.segmentEquals(c2)) continue;
            return null;
        }
        if (c1 == null && c2 == null) {
            return EMPTY;
        }
        if (c1 == null || c1.isIndexed()) {
            return null;
        }
        return new FieldPath((FieldSegment.NameSegment)c1.clone());
    }

    public boolean isAtOrBelow(FieldPath other) {
        return this.rootSegment.isAtOrBelow(other.rootSegment);
    }

    public boolean isAtOrAbove(FieldPath other) {
        return this.rootSegment.isAtOrAbove(other.rootSegment);
    }

    public FieldSegment segmentAfterAncestor(FieldPath ancestor) {
        if (this.equals(ancestor)) {
            return EMPTY.getRootSegment();
        }
        FieldSegment fseg = this.rootSegment;
        for (FieldSegment aseg = ancestor.getRootSegment(); fseg != null && aseg != null; fseg = fseg.getChild(), aseg = aseg.getChild()) {
            if (fseg.segmentEquals(aseg)) continue;
            if (fseg.isNamed() && aseg.isNamed() && ((FieldSegment.NameSegment)fseg).getName().equals(((FieldSegment.NameSegment)aseg).getName()) && fseg.isArray() && aseg.isLeaf()) {
                return fseg;
            }
            return null;
        }
        return fseg;
    }

    @API.Internal
    public FieldPath(FieldSegment.NameSegment root) {
        this.rootSegment = root;
    }

    static final class FieldPathErrorListener
    extends BaseErrorListener {
        private String errorMsg;
        private RecognitionException exception;

        FieldPathErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errorMsg = String.format("At line:%d:%d: %s", line, charPositionInLine, msg);
            this.exception = e;
        }

        public boolean isError() {
            return this.errorMsg != null;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public RecognitionException getException() {
            return this.exception;
        }
    }

    final class FieldSegmentIterator
    implements Iterator<FieldSegment> {
        FieldSegment current;

        FieldSegmentIterator() {
            this.current = FieldPath.this.rootSegment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldSegment next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            FieldSegment ret = this.current;
            this.current = this.current.getChild();
            return ret;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }
    }
}

